package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait GitPullRequestEventType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType
}
object GitPullRequestEventType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType
  ): zio.aws.codepipeline.model.GitPullRequestEventType = value match {
    case software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.UPDATED =>
      val r = UPDATED
      r
    case software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.GitPullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType =
      software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.codepipeline.model.GitPullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType =
      software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.OPEN
  }
  case object UPDATED
      extends zio.aws.codepipeline.model.GitPullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType =
      software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.UPDATED
  }
  case object CLOSED
      extends zio.aws.codepipeline.model.GitPullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType =
      software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType.CLOSED
  }
}
