package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GitPullRequestFilter(
    events: Optional[
      Iterable[zio.aws.codepipeline.model.GitPullRequestEventType]
    ] = Optional.Absent,
    branches: Optional[zio.aws.codepipeline.model.GitBranchFilterCriteria] =
      Optional.Absent,
    filePaths: Optional[zio.aws.codepipeline.model.GitFilePathFilterCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitPullRequestFilter = {
    import GitPullRequestFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitPullRequestFilter
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventsWithStrings)
      .optionallyWith(branches.map(value => value.buildAwsValue()))(_.branches)
      .optionallyWith(filePaths.map(value => value.buildAwsValue()))(
        _.filePaths
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GitPullRequestFilter.ReadOnly =
    zio.aws.codepipeline.model.GitPullRequestFilter.wrap(buildAwsValue())
}
object GitPullRequestFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitPullRequestFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitPullRequestFilter =
      zio.aws.codepipeline.model.GitPullRequestFilter(
        events.map(value => value),
        branches.map(value => value.asEditable),
        filePaths.map(value => value.asEditable)
      )
    def events
        : Optional[List[zio.aws.codepipeline.model.GitPullRequestEventType]]
    def branches
        : Optional[zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly]
    def filePaths: Optional[
      zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly
    ]
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.GitPullRequestEventType
    ]] = AwsError.unwrapOptionField("events", events)
    def getBranches: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("branches", branches)
    def getFilePaths: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filePaths", filePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitPullRequestFilter
  ) extends zio.aws.codepipeline.model.GitPullRequestFilter.ReadOnly {
    override val events
        : Optional[List[zio.aws.codepipeline.model.GitPullRequestEventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.GitPullRequestEventType.wrap(item)
          }.toList
        )
    override val branches: Optional[
      zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.branches())
      .map(value =>
        zio.aws.codepipeline.model.GitBranchFilterCriteria.wrap(value)
      )
    override val filePaths: Optional[
      zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filePaths())
      .map(value =>
        zio.aws.codepipeline.model.GitFilePathFilterCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitPullRequestFilter
  ): zio.aws.codepipeline.model.GitPullRequestFilter.ReadOnly = new Wrapper(
    impl
  )
}
