package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  NextToken,
  MaxResults,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class ListRuleExecutionsRequest(
    pipelineName: PipelineName,
    filter: Optional[zio.aws.codepipeline.model.RuleExecutionFilter] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest = {
    import ListRuleExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListRuleExecutionsRequest.ReadOnly =
    zio.aws.codepipeline.model.ListRuleExecutionsRequest.wrap(buildAwsValue())
}
object ListRuleExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListRuleExecutionsRequest =
      zio.aws.codepipeline.model.ListRuleExecutionsRequest(
        pipelineName,
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def pipelineName: PipelineName
    def filter
        : Optional[zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest
  ) extends zio.aws.codepipeline.model.ListRuleExecutionsRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val filter
        : Optional[zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.codepipeline.model.RuleExecutionFilter.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codepipeline.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest
  ): zio.aws.codepipeline.model.ListRuleExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
