package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListRuleTypesResponse(
    ruleTypes: Iterable[zio.aws.codepipeline.model.RuleType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse = {
    import ListRuleTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse
      .builder()
      .ruleTypes(ruleTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListRuleTypesResponse.ReadOnly =
    zio.aws.codepipeline.model.ListRuleTypesResponse.wrap(buildAwsValue())
}
object ListRuleTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListRuleTypesResponse =
      zio.aws.codepipeline.model.ListRuleTypesResponse(ruleTypes.map { item =>
        item.asEditable
      })
    def ruleTypes: List[zio.aws.codepipeline.model.RuleType.ReadOnly]
    def getRuleTypes: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.RuleType.ReadOnly
    ]] = ZIO.succeed(ruleTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse
  ) extends zio.aws.codepipeline.model.ListRuleTypesResponse.ReadOnly {
    override val ruleTypes: List[zio.aws.codepipeline.model.RuleType.ReadOnly] =
      impl
        .ruleTypes()
        .asScala
        .map { item =>
          zio.aws.codepipeline.model.RuleType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse
  ): zio.aws.codepipeline.model.ListRuleTypesResponse.ReadOnly = new Wrapper(
    impl
  )
}
