package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PipelineExecutionFilter(
    succeededInStage: Optional[
      zio.aws.codepipeline.model.SucceededInStageFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionFilter = {
    import PipelineExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionFilter
      .builder()
      .optionallyWith(succeededInStage.map(value => value.buildAwsValue()))(
        _.succeededInStage
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineExecutionFilter.ReadOnly =
    zio.aws.codepipeline.model.PipelineExecutionFilter.wrap(buildAwsValue())
}
object PipelineExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineExecutionFilter =
      zio.aws.codepipeline.model.PipelineExecutionFilter(
        succeededInStage.map(value => value.asEditable)
      )
    def succeededInStage
        : Optional[zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly]
    def getSucceededInStage: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly
    ] = AwsError.unwrapOptionField("succeededInStage", succeededInStage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionFilter
  ) extends zio.aws.codepipeline.model.PipelineExecutionFilter.ReadOnly {
    override val succeededInStage
        : Optional[zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.succeededInStage())
        .map(value =>
          zio.aws.codepipeline.model.SucceededInStageFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionFilter
  ): zio.aws.codepipeline.model.PipelineExecutionFilter.ReadOnly = new Wrapper(
    impl
  )
}
