package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  PipelineExecutionStatusSummary,
  PipelineExecutionId
}
import scala.jdk.CollectionConverters.*
final case class PipelineExecutionSummary(
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent,
    status: Optional[zio.aws.codepipeline.model.PipelineExecutionStatus] =
      Optional.Absent,
    statusSummary: Optional[PipelineExecutionStatusSummary] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    sourceRevisions: Optional[
      Iterable[zio.aws.codepipeline.model.SourceRevision]
    ] = Optional.Absent,
    trigger: Optional[zio.aws.codepipeline.model.ExecutionTrigger] =
      Optional.Absent,
    stopTrigger: Optional[zio.aws.codepipeline.model.StopExecutionTrigger] =
      Optional.Absent,
    executionMode: Optional[zio.aws.codepipeline.model.ExecutionMode] =
      Optional.Absent,
    executionType: Optional[zio.aws.codepipeline.model.ExecutionType] =
      Optional.Absent,
    rollbackMetadata: Optional[
      zio.aws.codepipeline.model.PipelineRollbackMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary = {
    import PipelineExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusSummary.map(value =>
          PipelineExecutionStatusSummary.unwrap(value): java.lang.String
        )
      )(_.statusSummary)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        sourceRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceRevisions)
      .optionallyWith(trigger.map(value => value.buildAwsValue()))(_.trigger)
      .optionallyWith(stopTrigger.map(value => value.buildAwsValue()))(
        _.stopTrigger
      )
      .optionallyWith(executionMode.map(value => value.unwrap))(_.executionMode)
      .optionallyWith(executionType.map(value => value.unwrap))(_.executionType)
      .optionallyWith(rollbackMetadata.map(value => value.buildAwsValue()))(
        _.rollbackMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly =
    zio.aws.codepipeline.model.PipelineExecutionSummary.wrap(buildAwsValue())
}
object PipelineExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineExecutionSummary =
      zio.aws.codepipeline.model.PipelineExecutionSummary(
        pipelineExecutionId.map(value => value),
        status.map(value => value),
        statusSummary.map(value => value),
        startTime.map(value => value),
        lastUpdateTime.map(value => value),
        sourceRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trigger.map(value => value.asEditable),
        stopTrigger.map(value => value.asEditable),
        executionMode.map(value => value),
        executionType.map(value => value),
        rollbackMetadata.map(value => value.asEditable)
      )
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def status: Optional[zio.aws.codepipeline.model.PipelineExecutionStatus]
    def statusSummary: Optional[PipelineExecutionStatusSummary]
    def startTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def sourceRevisions
        : Optional[List[zio.aws.codepipeline.model.SourceRevision.ReadOnly]]
    def trigger: Optional[zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly]
    def stopTrigger
        : Optional[zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly]
    def executionMode: Optional[zio.aws.codepipeline.model.ExecutionMode]
    def executionType: Optional[zio.aws.codepipeline.model.ExecutionType]
    def rollbackMetadata
        : Optional[zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusSummary: ZIO[Any, AwsError, PipelineExecutionStatusSummary] =
      AwsError.unwrapOptionField("statusSummary", statusSummary)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getSourceRevisions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.SourceRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceRevisions", sourceRevisions)
    def getTrigger: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly
    ] = AwsError.unwrapOptionField("trigger", trigger)
    def getStopTrigger: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly
    ] = AwsError.unwrapOptionField("stopTrigger", stopTrigger)
    def getExecutionMode
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ExecutionMode] =
      AwsError.unwrapOptionField("executionMode", executionMode)
    def getExecutionType
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ExecutionType] =
      AwsError.unwrapOptionField("executionType", executionType)
    def getRollbackMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("rollbackMetadata", rollbackMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ) extends zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly {
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
    override val status
        : Optional[zio.aws.codepipeline.model.PipelineExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.PipelineExecutionStatus.wrap(value)
        )
    override val statusSummary: Optional[PipelineExecutionStatusSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .PipelineExecutionStatusSummary(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val sourceRevisions
        : Optional[List[zio.aws.codepipeline.model.SourceRevision.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRevisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.SourceRevision.wrap(item)
          }.toList
        )
    override val trigger
        : Optional[zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trigger())
        .map(value => zio.aws.codepipeline.model.ExecutionTrigger.wrap(value))
    override val stopTrigger
        : Optional[zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stopTrigger())
        .map(value =>
          zio.aws.codepipeline.model.StopExecutionTrigger.wrap(value)
        )
    override val executionMode
        : Optional[zio.aws.codepipeline.model.ExecutionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionMode())
        .map(value => zio.aws.codepipeline.model.ExecutionMode.wrap(value))
    override val executionType
        : Optional[zio.aws.codepipeline.model.ExecutionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionType())
        .map(value => zio.aws.codepipeline.model.ExecutionType.wrap(value))
    override val rollbackMetadata: Optional[
      zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackMetadata())
      .map(value =>
        zio.aws.codepipeline.model.PipelineRollbackMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ): zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
