package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PipelineRollbackMetadata(
    rollbackTargetPipelineExecutionId: Optional[PipelineExecutionId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata = {
    import PipelineRollbackMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata
      .builder()
      .optionallyWith(
        rollbackTargetPipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.rollbackTargetPipelineExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly =
    zio.aws.codepipeline.model.PipelineRollbackMetadata.wrap(buildAwsValue())
}
object PipelineRollbackMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineRollbackMetadata =
      zio.aws.codepipeline.model.PipelineRollbackMetadata(
        rollbackTargetPipelineExecutionId.map(value => value)
      )
    def rollbackTargetPipelineExecutionId: Optional[PipelineExecutionId]
    def getRollbackTargetPipelineExecutionId
        : ZIO[Any, AwsError, PipelineExecutionId] = AwsError.unwrapOptionField(
      "rollbackTargetPipelineExecutionId",
      rollbackTargetPipelineExecutionId
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata
  ) extends zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly {
    override val rollbackTargetPipelineExecutionId
        : Optional[PipelineExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackTargetPipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata
  ): zio.aws.codepipeline.model.PipelineRollbackMetadata.ReadOnly = new Wrapper(
    impl
  )
}
