package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.WebhookName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterWebhookWithThirdPartyRequest(
    webhookName: Optional[WebhookName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest = {
    import RegisterWebhookWithThirdPartyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest
      .builder()
      .optionallyWith(
        webhookName.map(value => WebhookName.unwrap(value): java.lang.String)
      )(_.webhookName)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest.ReadOnly =
    zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest
      .wrap(buildAwsValue())
}
object RegisterWebhookWithThirdPartyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest =
      zio.aws.codepipeline.model
        .RegisterWebhookWithThirdPartyRequest(webhookName.map(value => value))
    def webhookName: Optional[WebhookName]
    def getWebhookName: ZIO[Any, AwsError, WebhookName] =
      AwsError.unwrapOptionField("webhookName", webhookName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest
  ) extends zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest.ReadOnly {
    override val webhookName: Optional[WebhookName] = zio.aws.core.internal
      .optionalFromNullable(impl.webhookName())
      .map(value => zio.aws.codepipeline.model.primitives.WebhookName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest
  ): zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyRequest.ReadOnly =
    new Wrapper(impl)
}
