package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.RetryAttempt
import scala.jdk.CollectionConverters.*
final case class RetryStageMetadata(
    autoStageRetryAttempt: Optional[RetryAttempt] = Optional.Absent,
    manualStageRetryAttempt: Optional[RetryAttempt] = Optional.Absent,
    latestRetryTrigger: Optional[zio.aws.codepipeline.model.RetryTrigger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata = {
    import RetryStageMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata
      .builder()
      .optionallyWith(
        autoStageRetryAttempt.map(value => RetryAttempt.unwrap(value): Integer)
      )(_.autoStageRetryAttempt)
      .optionallyWith(
        manualStageRetryAttempt.map(value =>
          RetryAttempt.unwrap(value): Integer
        )
      )(_.manualStageRetryAttempt)
      .optionallyWith(latestRetryTrigger.map(value => value.unwrap))(
        _.latestRetryTrigger
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly =
    zio.aws.codepipeline.model.RetryStageMetadata.wrap(buildAwsValue())
}
object RetryStageMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RetryStageMetadata =
      zio.aws.codepipeline.model.RetryStageMetadata(
        autoStageRetryAttempt.map(value => value),
        manualStageRetryAttempt.map(value => value),
        latestRetryTrigger.map(value => value)
      )
    def autoStageRetryAttempt: Optional[RetryAttempt]
    def manualStageRetryAttempt: Optional[RetryAttempt]
    def latestRetryTrigger: Optional[zio.aws.codepipeline.model.RetryTrigger]
    def getAutoStageRetryAttempt: ZIO[Any, AwsError, RetryAttempt] =
      AwsError.unwrapOptionField("autoStageRetryAttempt", autoStageRetryAttempt)
    def getManualStageRetryAttempt: ZIO[Any, AwsError, RetryAttempt] = AwsError
      .unwrapOptionField("manualStageRetryAttempt", manualStageRetryAttempt)
    def getLatestRetryTrigger
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RetryTrigger] =
      AwsError.unwrapOptionField("latestRetryTrigger", latestRetryTrigger)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata
  ) extends zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly {
    override val autoStageRetryAttempt: Optional[RetryAttempt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStageRetryAttempt())
        .map(value => zio.aws.codepipeline.model.primitives.RetryAttempt(value))
    override val manualStageRetryAttempt: Optional[RetryAttempt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualStageRetryAttempt())
        .map(value => zio.aws.codepipeline.model.primitives.RetryAttempt(value))
    override val latestRetryTrigger
        : Optional[zio.aws.codepipeline.model.RetryTrigger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRetryTrigger())
        .map(value => zio.aws.codepipeline.model.RetryTrigger.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata
  ): zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly = new Wrapper(impl)
}
