package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait RetryTrigger {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.RetryTrigger
}
object RetryTrigger {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.RetryTrigger
  ): zio.aws.codepipeline.model.RetryTrigger = value match {
    case software.amazon.awssdk.services.codepipeline.model.RetryTrigger.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.RetryTrigger.AUTOMATED_STAGE_RETRY =>
      val r = AutomatedStageRetry
      r
    case software.amazon.awssdk.services.codepipeline.model.RetryTrigger.MANUAL_STAGE_RETRY =>
      val r = ManualStageRetry
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.RetryTrigger {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RetryTrigger =
      software.amazon.awssdk.services.codepipeline.model.RetryTrigger.UNKNOWN_TO_SDK_VERSION
  }
  case object AutomatedStageRetry
      extends zio.aws.codepipeline.model.RetryTrigger {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RetryTrigger =
      software.amazon.awssdk.services.codepipeline.model.RetryTrigger.AUTOMATED_STAGE_RETRY
  }
  case object ManualStageRetry extends zio.aws.codepipeline.model.RetryTrigger {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RetryTrigger =
      software.amazon.awssdk.services.codepipeline.model.RetryTrigger.MANUAL_STAGE_RETRY
  }
}
