package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionId,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RollbackStageRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    targetPipelineExecutionId: PipelineExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest = {
    import RollbackStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .targetPipelineExecutionId(
        PipelineExecutionId.unwrap(targetPipelineExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RollbackStageRequest.ReadOnly =
    zio.aws.codepipeline.model.RollbackStageRequest.wrap(buildAwsValue())
}
object RollbackStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RollbackStageRequest =
      zio.aws.codepipeline.model.RollbackStageRequest(
        pipelineName,
        stageName,
        targetPipelineExecutionId
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def targetPipelineExecutionId: PipelineExecutionId
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getTargetPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(targetPipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest
  ) extends zio.aws.codepipeline.model.RollbackStageRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val targetPipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.targetPipelineExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest
  ): zio.aws.codepipeline.model.RollbackStageRequest.ReadOnly = new Wrapper(
    impl
  )
}
