package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait RuleCategory {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.RuleCategory
}
object RuleCategory {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.RuleCategory
  ): zio.aws.codepipeline.model.RuleCategory = value match {
    case software.amazon.awssdk.services.codepipeline.model.RuleCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleCategory.RULE =>
      val r = Rule
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.RuleCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleCategory =
      software.amazon.awssdk.services.codepipeline.model.RuleCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object Rule extends zio.aws.codepipeline.model.RuleCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleCategory =
      software.amazon.awssdk.services.codepipeline.model.RuleCategory.RULE
  }
}
