package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Description, RuleConfigurationKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleConfigurationProperty(
    name: RuleConfigurationKey,
    required: Boolean,
    key: Boolean,
    secret: Boolean,
    queryable: Optional[Boolean] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    `type`: Optional[zio.aws.codepipeline.model.RuleConfigurationPropertyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty = {
    import RuleConfigurationProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty
      .builder()
      .name(RuleConfigurationKey.unwrap(name): java.lang.String)
      .required(required: java.lang.Boolean)
      .key(key: java.lang.Boolean)
      .secret(secret: java.lang.Boolean)
      .optionallyWith(queryable.map(value => value: java.lang.Boolean))(
        _.queryable
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly =
    zio.aws.codepipeline.model.RuleConfigurationProperty.wrap(buildAwsValue())
}
object RuleConfigurationProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleConfigurationProperty =
      zio.aws.codepipeline.model.RuleConfigurationProperty(
        name,
        required,
        key,
        secret,
        queryable.map(value => value),
        description.map(value => value),
        `type`.map(value => value)
      )
    def name: RuleConfigurationKey
    def required: Boolean
    def key: Boolean
    def secret: Boolean
    def queryable: Optional[Boolean]
    def description: Optional[Description]
    def `type`
        : Optional[zio.aws.codepipeline.model.RuleConfigurationPropertyType]
    def getName: ZIO[Any, Nothing, RuleConfigurationKey] = ZIO.succeed(name)
    def getRequired: ZIO[Any, Nothing, Boolean] = ZIO.succeed(required)
    def getKey: ZIO[Any, Nothing, Boolean] = ZIO.succeed(key)
    def getSecret: ZIO[Any, Nothing, Boolean] = ZIO.succeed(secret)
    def getQueryable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("queryable", queryable)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleConfigurationPropertyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty
  ) extends zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly {
    override val name: RuleConfigurationKey =
      zio.aws.codepipeline.model.primitives.RuleConfigurationKey(impl.name())
    override val required: Boolean = impl.required(): Boolean
    override val key: Boolean = impl.key(): Boolean
    override val secret: Boolean = impl.secret(): Boolean
    override val queryable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.queryable())
      .map(value => value: Boolean)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codepipeline.model.primitives.Description(value))
    override val `type`
        : Optional[zio.aws.codepipeline.model.RuleConfigurationPropertyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.codepipeline.model.RuleConfigurationPropertyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty
  ): zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly =
    new Wrapper(impl)
}
