package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  RuleConfigurationValue,
  RoleArn,
  RuleConfigurationKey,
  RuleName,
  Command,
  RuleTimeout,
  AWSRegionName
}
import scala.jdk.CollectionConverters.*
final case class RuleDeclaration(
    name: RuleName,
    ruleTypeId: zio.aws.codepipeline.model.RuleTypeId,
    configuration: Optional[Map[RuleConfigurationKey, RuleConfigurationValue]] =
      Optional.Absent,
    commands: Optional[Iterable[Command]] = Optional.Absent,
    inputArtifacts: Optional[
      Iterable[zio.aws.codepipeline.model.InputArtifact]
    ] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    region: Optional[AWSRegionName] = Optional.Absent,
    timeoutInMinutes: Optional[RuleTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleDeclaration = {
    import RuleDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleDeclaration
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .ruleTypeId(ruleTypeId.buildAwsValue())
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (RuleConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (RuleConfigurationValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        commands.map(value =>
          value.map { item =>
            Command.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.commands)
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        region.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        timeoutInMinutes.map(value => RuleTimeout.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleDeclaration.ReadOnly =
    zio.aws.codepipeline.model.RuleDeclaration.wrap(buildAwsValue())
}
object RuleDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleDeclaration =
      zio.aws.codepipeline.model.RuleDeclaration(
        name,
        ruleTypeId.asEditable,
        configuration.map(value => value),
        commands.map(value => value),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value),
        region.map(value => value),
        timeoutInMinutes.map(value => value)
      )
    def name: RuleName
    def ruleTypeId: zio.aws.codepipeline.model.RuleTypeId.ReadOnly
    def configuration
        : Optional[Map[RuleConfigurationKey, RuleConfigurationValue]]
    def commands: Optional[List[Command]]
    def inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]]
    def roleArn: Optional[RoleArn]
    def region: Optional[AWSRegionName]
    def timeoutInMinutes: Optional[RuleTimeout]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getRuleTypeId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.RuleTypeId.ReadOnly] =
      ZIO.succeed(ruleTypeId)
    def getConfiguration: ZIO[Any, AwsError, Map[
      RuleConfigurationKey,
      RuleConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getCommands: ZIO[Any, AwsError, List[Command]] =
      AwsError.unwrapOptionField("commands", commands)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.InputArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRegion: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("region", region)
    def getTimeoutInMinutes: ZIO[Any, AwsError, RuleTimeout] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleDeclaration
  ) extends zio.aws.codepipeline.model.RuleDeclaration.ReadOnly {
    override val name: RuleName =
      zio.aws.codepipeline.model.primitives.RuleName(impl.name())
    override val ruleTypeId: zio.aws.codepipeline.model.RuleTypeId.ReadOnly =
      zio.aws.codepipeline.model.RuleTypeId.wrap(impl.ruleTypeId())
    override val configuration
        : Optional[Map[RuleConfigurationKey, RuleConfigurationValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codepipeline.model.primitives.RuleConfigurationKey(
                key
              ) -> zio.aws.codepipeline.model.primitives
                .RuleConfigurationValue(value)
            })
            .toMap
        )
    override val commands: Optional[List[Command]] = zio.aws.core.internal
      .optionalFromNullable(impl.commands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.primitives.Command(item)
        }.toList
      )
    override val inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.InputArtifact.wrap(item)
          }.toList
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.codepipeline.model.primitives.RoleArn(value))
    override val region: Optional[AWSRegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
    override val timeoutInMinutes: Optional[RuleTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMinutes())
      .map(value => zio.aws.codepipeline.model.primitives.RuleTimeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleDeclaration
  ): zio.aws.codepipeline.model.RuleDeclaration.ReadOnly = new Wrapper(impl)
}
