package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{
  Url,
  Timestamp,
  ExecutionId,
  ExecutionSummary,
  RuleExecutionToken,
  LastUpdatedBy,
  RuleExecutionId
}
import scala.jdk.CollectionConverters.*
final case class RuleExecution(
    ruleExecutionId: Optional[RuleExecutionId] = Optional.Absent,
    status: Optional[zio.aws.codepipeline.model.RuleExecutionStatus] =
      Optional.Absent,
    summary: Optional[ExecutionSummary] = Optional.Absent,
    lastStatusChange: Optional[Timestamp] = Optional.Absent,
    token: Optional[RuleExecutionToken] = Optional.Absent,
    lastUpdatedBy: Optional[LastUpdatedBy] = Optional.Absent,
    externalExecutionId: Optional[ExecutionId] = Optional.Absent,
    externalExecutionUrl: Optional[Url] = Optional.Absent,
    errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecution = {
    import RuleExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecution
      .builder()
      .optionallyWith(
        ruleExecutionId.map(value =>
          RuleExecutionId.unwrap(value): java.lang.String
        )
      )(_.ruleExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .optionallyWith(
        token.map(value => RuleExecutionToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        externalExecutionId.map(value =>
          ExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        externalExecutionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.externalExecutionUrl)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecution.ReadOnly =
    zio.aws.codepipeline.model.RuleExecution.wrap(buildAwsValue())
}
object RuleExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecution =
      zio.aws.codepipeline.model.RuleExecution(
        ruleExecutionId.map(value => value),
        status.map(value => value),
        summary.map(value => value),
        lastStatusChange.map(value => value),
        token.map(value => value),
        lastUpdatedBy.map(value => value),
        externalExecutionId.map(value => value),
        externalExecutionUrl.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def ruleExecutionId: Optional[RuleExecutionId]
    def status: Optional[zio.aws.codepipeline.model.RuleExecutionStatus]
    def summary: Optional[ExecutionSummary]
    def lastStatusChange: Optional[Timestamp]
    def token: Optional[RuleExecutionToken]
    def lastUpdatedBy: Optional[LastUpdatedBy]
    def externalExecutionId: Optional[ExecutionId]
    def externalExecutionUrl: Optional[Url]
    def errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly]
    def getRuleExecutionId: ZIO[Any, AwsError, RuleExecutionId] =
      AwsError.unwrapOptionField("ruleExecutionId", ruleExecutionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getToken: ZIO[Any, AwsError, RuleExecutionToken] =
      AwsError.unwrapOptionField("token", token)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getExternalExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getExternalExecutionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("externalExecutionUrl", externalExecutionUrl)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecution
  ) extends zio.aws.codepipeline.model.RuleExecution.ReadOnly {
    override val ruleExecutionId: Optional[RuleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RuleExecutionId(value)
        )
    override val status
        : Optional[zio.aws.codepipeline.model.RuleExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.RuleExecutionStatus.wrap(value)
        )
    override val summary: Optional[ExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
    override val lastStatusChange: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChange())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val token: Optional[RuleExecutionToken] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value =>
        zio.aws.codepipeline.model.primitives.RuleExecutionToken(value)
      )
    override val lastUpdatedBy: Optional[LastUpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.codepipeline.model.primitives.LastUpdatedBy(value))
    override val externalExecutionId: Optional[ExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalExecutionId())
        .map(value => zio.aws.codepipeline.model.primitives.ExecutionId(value))
    override val externalExecutionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.externalExecutionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val errorDetails
        : Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.codepipeline.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecution
  ): zio.aws.codepipeline.model.RuleExecution.ReadOnly = new Wrapper(impl)
}
