package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  PipelineVersion,
  Timestamp,
  RuleName,
  LastUpdatedBy,
  PipelineExecutionId,
  RuleExecutionId,
  StageName
}
import scala.jdk.CollectionConverters.*
final case class RuleExecutionDetail(
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent,
    ruleExecutionId: Optional[RuleExecutionId] = Optional.Absent,
    pipelineVersion: Optional[PipelineVersion] = Optional.Absent,
    stageName: Optional[StageName] = Optional.Absent,
    ruleName: Optional[RuleName] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    updatedBy: Optional[LastUpdatedBy] = Optional.Absent,
    status: Optional[zio.aws.codepipeline.model.RuleExecutionStatus] =
      Optional.Absent,
    input: Optional[zio.aws.codepipeline.model.RuleExecutionInput] =
      Optional.Absent,
    output: Optional[zio.aws.codepipeline.model.RuleExecutionOutput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail = {
    import RuleExecutionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(
        ruleExecutionId.map(value =>
          RuleExecutionId.unwrap(value): java.lang.String
        )
      )(_.ruleExecutionId)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        updatedBy.map(value => LastUpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly =
    zio.aws.codepipeline.model.RuleExecutionDetail.wrap(buildAwsValue())
}
object RuleExecutionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecutionDetail =
      zio.aws.codepipeline.model.RuleExecutionDetail(
        pipelineExecutionId.map(value => value),
        ruleExecutionId.map(value => value),
        pipelineVersion.map(value => value),
        stageName.map(value => value),
        ruleName.map(value => value),
        startTime.map(value => value),
        lastUpdateTime.map(value => value),
        updatedBy.map(value => value),
        status.map(value => value),
        input.map(value => value.asEditable),
        output.map(value => value.asEditable)
      )
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def ruleExecutionId: Optional[RuleExecutionId]
    def pipelineVersion: Optional[PipelineVersion]
    def stageName: Optional[StageName]
    def ruleName: Optional[RuleName]
    def startTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def updatedBy: Optional[LastUpdatedBy]
    def status: Optional[zio.aws.codepipeline.model.RuleExecutionStatus]
    def input: Optional[zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly]
    def output
        : Optional[zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getRuleExecutionId: ZIO[Any, AwsError, RuleExecutionId] =
      AwsError.unwrapOptionField("ruleExecutionId", ruleExecutionId)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail
  ) extends zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly {
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
    override val ruleExecutionId: Optional[RuleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RuleExecutionId(value)
        )
    override val pipelineVersion: Optional[PipelineVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineVersion())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineVersion(value)
        )
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
    override val ruleName: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.codepipeline.model.primitives.RuleName(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updatedBy: Optional[LastUpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.codepipeline.model.primitives.LastUpdatedBy(value))
    override val status
        : Optional[zio.aws.codepipeline.model.RuleExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.RuleExecutionStatus.wrap(value)
        )
    override val input
        : Optional[zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.input())
        .map(value => zio.aws.codepipeline.model.RuleExecutionInput.wrap(value))
    override val output
        : Optional[zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.output())
        .map(value =>
          zio.aws.codepipeline.model.RuleExecutionOutput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail
  ): zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly = new Wrapper(impl)
}
