package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait RuleExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus
}
object RuleExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus
  ): zio.aws.codepipeline.model.RuleExecutionStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.ABANDONED =>
      val r = Abandoned
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.RuleExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.codepipeline.model.RuleExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.IN_PROGRESS
  }
  case object Abandoned extends zio.aws.codepipeline.model.RuleExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.ABANDONED
  }
  case object Succeeded extends zio.aws.codepipeline.model.RuleExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codepipeline.model.RuleExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus.FAILED
  }
}
