package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  RevisionChangeIdentifier,
  Revision
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RuleRevision(
    revisionId: Revision,
    revisionChangeId: RevisionChangeIdentifier,
    created: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleRevision = {
    import RuleRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleRevision
      .builder()
      .revisionId(Revision.unwrap(revisionId): java.lang.String)
      .revisionChangeId(
        RevisionChangeIdentifier.unwrap(revisionChangeId): java.lang.String
      )
      .created(Timestamp.unwrap(created): Instant)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleRevision.ReadOnly =
    zio.aws.codepipeline.model.RuleRevision.wrap(buildAwsValue())
}
object RuleRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleRevision =
      zio.aws.codepipeline.model
        .RuleRevision(revisionId, revisionChangeId, created)
    def revisionId: Revision
    def revisionChangeId: RevisionChangeIdentifier
    def created: Timestamp
    def getRevisionId: ZIO[Any, Nothing, Revision] = ZIO.succeed(revisionId)
    def getRevisionChangeId: ZIO[Any, Nothing, RevisionChangeIdentifier] =
      ZIO.succeed(revisionChangeId)
    def getCreated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(created)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleRevision
  ) extends zio.aws.codepipeline.model.RuleRevision.ReadOnly {
    override val revisionId: Revision =
      zio.aws.codepipeline.model.primitives.Revision(impl.revisionId())
    override val revisionChangeId: RevisionChangeIdentifier =
      zio.aws.codepipeline.model.primitives
        .RevisionChangeIdentifier(impl.revisionChangeId())
    override val created: Timestamp =
      zio.aws.codepipeline.model.primitives.Timestamp(impl.created())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleRevision
  ): zio.aws.codepipeline.model.RuleRevision.ReadOnly = new Wrapper(impl)
}
