package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleType(
    id: zio.aws.codepipeline.model.RuleTypeId,
    settings: Optional[zio.aws.codepipeline.model.RuleTypeSettings] =
      Optional.Absent,
    ruleConfigurationProperties: Optional[
      Iterable[zio.aws.codepipeline.model.RuleConfigurationProperty]
    ] = Optional.Absent,
    inputArtifactDetails: zio.aws.codepipeline.model.ArtifactDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleType = {
    import RuleType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleType
      .builder()
      .id(id.buildAwsValue())
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        ruleConfigurationProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleConfigurationProperties)
      .inputArtifactDetails(inputArtifactDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleType.ReadOnly =
    zio.aws.codepipeline.model.RuleType.wrap(buildAwsValue())
}
object RuleType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleType =
      zio.aws.codepipeline.model.RuleType(
        id.asEditable,
        settings.map(value => value.asEditable),
        ruleConfigurationProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputArtifactDetails.asEditable
      )
    def id: zio.aws.codepipeline.model.RuleTypeId.ReadOnly
    def settings: Optional[zio.aws.codepipeline.model.RuleTypeSettings.ReadOnly]
    def ruleConfigurationProperties: Optional[
      List[zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly]
    ]
    def inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    def getId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.RuleTypeId.ReadOnly] =
      ZIO.succeed(id)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleTypeSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getRuleConfigurationProperties: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ruleConfigurationProperties",
      ruleConfigurationProperties
    )
    def getInputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    ] = ZIO.succeed(inputArtifactDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleType
  ) extends zio.aws.codepipeline.model.RuleType.ReadOnly {
    override val id: zio.aws.codepipeline.model.RuleTypeId.ReadOnly =
      zio.aws.codepipeline.model.RuleTypeId.wrap(impl.id())
    override val settings
        : Optional[zio.aws.codepipeline.model.RuleTypeSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.codepipeline.model.RuleTypeSettings.wrap(value))
    override val ruleConfigurationProperties: Optional[
      List[zio.aws.codepipeline.model.RuleConfigurationProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleConfigurationProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.RuleConfigurationProperty.wrap(item)
        }.toList
      )
    override val inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ArtifactDetails
        .wrap(impl.inputArtifactDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleType
  ): zio.aws.codepipeline.model.RuleType.ReadOnly = new Wrapper(impl)
}
