package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Version, RuleProvider}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleTypeId(
    category: zio.aws.codepipeline.model.RuleCategory,
    owner: Optional[zio.aws.codepipeline.model.RuleOwner] = Optional.Absent,
    provider: RuleProvider,
    version: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleTypeId = {
    import RuleTypeId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleTypeId
      .builder()
      .category(category.unwrap)
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .provider(RuleProvider.unwrap(provider): java.lang.String)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleTypeId.ReadOnly =
    zio.aws.codepipeline.model.RuleTypeId.wrap(buildAwsValue())
}
object RuleTypeId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleTypeId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleTypeId =
      zio.aws.codepipeline.model.RuleTypeId(
        category,
        owner.map(value => value),
        provider,
        version.map(value => value)
      )
    def category: zio.aws.codepipeline.model.RuleCategory
    def owner: Optional[zio.aws.codepipeline.model.RuleOwner]
    def provider: RuleProvider
    def version: Optional[Version]
    def getCategory
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.RuleCategory] =
      ZIO.succeed(category)
    def getOwner: ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProvider: ZIO[Any, Nothing, RuleProvider] = ZIO.succeed(provider)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleTypeId
  ) extends zio.aws.codepipeline.model.RuleTypeId.ReadOnly {
    override val category: zio.aws.codepipeline.model.RuleCategory =
      zio.aws.codepipeline.model.RuleCategory.wrap(impl.category())
    override val owner: Optional[zio.aws.codepipeline.model.RuleOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.codepipeline.model.RuleOwner.wrap(value))
    override val provider: RuleProvider =
      zio.aws.codepipeline.model.primitives.RuleProvider(impl.provider())
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codepipeline.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleTypeId
  ): zio.aws.codepipeline.model.RuleTypeId.ReadOnly = new Wrapper(impl)
}
