package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Revision, ActionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SourceRevisionOverride(
    actionName: ActionName,
    revisionType: zio.aws.codepipeline.model.SourceRevisionType,
    revisionValue: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride = {
    import SourceRevisionOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride
      .builder()
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .revisionType(revisionType.unwrap)
      .revisionValue(Revision.unwrap(revisionValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly =
    zio.aws.codepipeline.model.SourceRevisionOverride.wrap(buildAwsValue())
}
object SourceRevisionOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.SourceRevisionOverride =
      zio.aws.codepipeline.model
        .SourceRevisionOverride(actionName, revisionType, revisionValue)
    def actionName: ActionName
    def revisionType: zio.aws.codepipeline.model.SourceRevisionType
    def revisionValue: Revision
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getRevisionType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.SourceRevisionType] =
      ZIO.succeed(revisionType)
    def getRevisionValue: ZIO[Any, Nothing, Revision] =
      ZIO.succeed(revisionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride
  ) extends zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly {
    override val actionName: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.actionName())
    override val revisionType: zio.aws.codepipeline.model.SourceRevisionType =
      zio.aws.codepipeline.model.SourceRevisionType.wrap(impl.revisionType())
    override val revisionValue: Revision =
      zio.aws.codepipeline.model.primitives.Revision(impl.revisionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride
  ): zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly = new Wrapper(
    impl
  )
}
