package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageConditionState(
    latestExecution: Optional[
      zio.aws.codepipeline.model.StageConditionsExecution
    ] = Optional.Absent,
    conditionStates: Optional[
      Iterable[zio.aws.codepipeline.model.ConditionState]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageConditionState = {
    import StageConditionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageConditionState
      .builder()
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .optionallyWith(
        conditionStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditionStates)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageConditionState.ReadOnly =
    zio.aws.codepipeline.model.StageConditionState.wrap(buildAwsValue())
}
object StageConditionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageConditionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageConditionState =
      zio.aws.codepipeline.model.StageConditionState(
        latestExecution.map(value => value.asEditable),
        conditionStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def latestExecution
        : Optional[zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly]
    def conditionStates
        : Optional[List[zio.aws.codepipeline.model.ConditionState.ReadOnly]]
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
    def getConditionStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ConditionState.ReadOnly
    ]] = AwsError.unwrapOptionField("conditionStates", conditionStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageConditionState
  ) extends zio.aws.codepipeline.model.StageConditionState.ReadOnly {
    override val latestExecution: Optional[
      zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestExecution())
      .map(value =>
        zio.aws.codepipeline.model.StageConditionsExecution.wrap(value)
      )
    override val conditionStates
        : Optional[List[zio.aws.codepipeline.model.ConditionState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ConditionState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageConditionState
  ): zio.aws.codepipeline.model.StageConditionState.ReadOnly = new Wrapper(impl)
}
