package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageExecution(
    pipelineExecutionId: PipelineExecutionId,
    status: zio.aws.codepipeline.model.StageExecutionStatus,
    `type`: Optional[zio.aws.codepipeline.model.ExecutionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageExecution = {
    import StageExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageExecution
      .builder()
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageExecution.ReadOnly =
    zio.aws.codepipeline.model.StageExecution.wrap(buildAwsValue())
}
object StageExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageExecution =
      zio.aws.codepipeline.model
        .StageExecution(pipelineExecutionId, status, `type`.map(value => value))
    def pipelineExecutionId: PipelineExecutionId
    def status: zio.aws.codepipeline.model.StageExecutionStatus
    def `type`: Optional[zio.aws.codepipeline.model.ExecutionType]
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StageExecutionStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, AwsError, zio.aws.codepipeline.model.ExecutionType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageExecution
  ) extends zio.aws.codepipeline.model.StageExecution.ReadOnly {
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val status: zio.aws.codepipeline.model.StageExecutionStatus =
      zio.aws.codepipeline.model.StageExecutionStatus.wrap(impl.status())
    override val `type`: Optional[zio.aws.codepipeline.model.ExecutionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codepipeline.model.ExecutionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageExecution
  ): zio.aws.codepipeline.model.StageExecution.ReadOnly = new Wrapper(impl)
}
