package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait StageRetryMode {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.StageRetryMode
}
object StageRetryMode {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.StageRetryMode
  ): zio.aws.codepipeline.model.StageRetryMode = value match {
    case software.amazon.awssdk.services.codepipeline.model.StageRetryMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.StageRetryMode.FAILED_ACTIONS =>
      val r = FAILED_ACTIONS
      r
    case software.amazon.awssdk.services.codepipeline.model.StageRetryMode.ALL_ACTIONS =>
      val r = ALL_ACTIONS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.StageRetryMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageRetryMode =
      software.amazon.awssdk.services.codepipeline.model.StageRetryMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED_ACTIONS extends zio.aws.codepipeline.model.StageRetryMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageRetryMode =
      software.amazon.awssdk.services.codepipeline.model.StageRetryMode.FAILED_ACTIONS
  }
  case object ALL_ACTIONS extends zio.aws.codepipeline.model.StageRetryMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageRetryMode =
      software.amazon.awssdk.services.codepipeline.model.StageRetryMode.ALL_ACTIONS
  }
}
