package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageState(
    stageName: Optional[StageName] = Optional.Absent,
    inboundExecution: Optional[zio.aws.codepipeline.model.StageExecution] =
      Optional.Absent,
    inboundExecutions: Optional[
      Iterable[zio.aws.codepipeline.model.StageExecution]
    ] = Optional.Absent,
    inboundTransitionState: Optional[
      zio.aws.codepipeline.model.TransitionState
    ] = Optional.Absent,
    actionStates: Optional[Iterable[zio.aws.codepipeline.model.ActionState]] =
      Optional.Absent,
    latestExecution: Optional[zio.aws.codepipeline.model.StageExecution] =
      Optional.Absent,
    beforeEntryConditionState: Optional[
      zio.aws.codepipeline.model.StageConditionState
    ] = Optional.Absent,
    onSuccessConditionState: Optional[
      zio.aws.codepipeline.model.StageConditionState
    ] = Optional.Absent,
    onFailureConditionState: Optional[
      zio.aws.codepipeline.model.StageConditionState
    ] = Optional.Absent,
    retryStageMetadata: Optional[
      zio.aws.codepipeline.model.RetryStageMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageState = {
    import StageState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageState
      .builder()
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(inboundExecution.map(value => value.buildAwsValue()))(
        _.inboundExecution
      )
      .optionallyWith(
        inboundExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inboundExecutions)
      .optionallyWith(
        inboundTransitionState.map(value => value.buildAwsValue())
      )(_.inboundTransitionState)
      .optionallyWith(
        actionStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionStates)
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .optionallyWith(
        beforeEntryConditionState.map(value => value.buildAwsValue())
      )(_.beforeEntryConditionState)
      .optionallyWith(
        onSuccessConditionState.map(value => value.buildAwsValue())
      )(_.onSuccessConditionState)
      .optionallyWith(
        onFailureConditionState.map(value => value.buildAwsValue())
      )(_.onFailureConditionState)
      .optionallyWith(retryStageMetadata.map(value => value.buildAwsValue()))(
        _.retryStageMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageState.ReadOnly =
    zio.aws.codepipeline.model.StageState.wrap(buildAwsValue())
}
object StageState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageState =
      zio.aws.codepipeline.model.StageState(
        stageName.map(value => value),
        inboundExecution.map(value => value.asEditable),
        inboundExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inboundTransitionState.map(value => value.asEditable),
        actionStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        latestExecution.map(value => value.asEditable),
        beforeEntryConditionState.map(value => value.asEditable),
        onSuccessConditionState.map(value => value.asEditable),
        onFailureConditionState.map(value => value.asEditable),
        retryStageMetadata.map(value => value.asEditable)
      )
    def stageName: Optional[StageName]
    def inboundExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def inboundExecutions
        : Optional[List[zio.aws.codepipeline.model.StageExecution.ReadOnly]]
    def inboundTransitionState
        : Optional[zio.aws.codepipeline.model.TransitionState.ReadOnly]
    def actionStates
        : Optional[List[zio.aws.codepipeline.model.ActionState.ReadOnly]]
    def latestExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def beforeEntryConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly]
    def onSuccessConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly]
    def onFailureConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly]
    def retryStageMetadata
        : Optional[zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly]
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getInboundExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("inboundExecution", inboundExecution)
    def getInboundExecutions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("inboundExecutions", inboundExecutions)
    def getInboundTransitionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.TransitionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboundTransitionState",
      inboundTransitionState
    )
    def getActionStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionState.ReadOnly
    ]] = AwsError.unwrapOptionField("actionStates", actionStates)
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
    def getBeforeEntryConditionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageConditionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "beforeEntryConditionState",
      beforeEntryConditionState
    )
    def getOnSuccessConditionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageConditionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onSuccessConditionState",
      onSuccessConditionState
    )
    def getOnFailureConditionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageConditionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onFailureConditionState",
      onFailureConditionState
    )
    def getRetryStageMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("retryStageMetadata", retryStageMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ) extends zio.aws.codepipeline.model.StageState.ReadOnly {
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
    override val inboundExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundExecution())
        .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
    override val inboundExecutions
        : Optional[List[zio.aws.codepipeline.model.StageExecution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.StageExecution.wrap(item)
          }.toList
        )
    override val inboundTransitionState
        : Optional[zio.aws.codepipeline.model.TransitionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundTransitionState())
        .map(value => zio.aws.codepipeline.model.TransitionState.wrap(value))
    override val actionStates
        : Optional[List[zio.aws.codepipeline.model.ActionState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ActionState.wrap(item)
          }.toList
        )
    override val latestExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestExecution())
        .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
    override val beforeEntryConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beforeEntryConditionState())
        .map(value =>
          zio.aws.codepipeline.model.StageConditionState.wrap(value)
        )
    override val onSuccessConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onSuccessConditionState())
        .map(value =>
          zio.aws.codepipeline.model.StageConditionState.wrap(value)
        )
    override val onFailureConditionState
        : Optional[zio.aws.codepipeline.model.StageConditionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onFailureConditionState())
        .map(value =>
          zio.aws.codepipeline.model.StageConditionState.wrap(value)
        )
    override val retryStageMetadata
        : Optional[zio.aws.codepipeline.model.RetryStageMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStageMetadata())
        .map(value => zio.aws.codepipeline.model.RetryStageMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ): zio.aws.codepipeline.model.StageState.ReadOnly = new Wrapper(impl)
}
