package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait StartTimeRange {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.StartTimeRange
}
object StartTimeRange {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.StartTimeRange
  ): zio.aws.codepipeline.model.StartTimeRange = value match {
    case software.amazon.awssdk.services.codepipeline.model.StartTimeRange.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.StartTimeRange.LATEST =>
      val r = Latest
      r
    case software.amazon.awssdk.services.codepipeline.model.StartTimeRange.ALL =>
      val r = All
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.StartTimeRange {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StartTimeRange =
      software.amazon.awssdk.services.codepipeline.model.StartTimeRange.UNKNOWN_TO_SDK_VERSION
  }
  case object Latest extends zio.aws.codepipeline.model.StartTimeRange {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StartTimeRange =
      software.amazon.awssdk.services.codepipeline.model.StartTimeRange.LATEST
  }
  case object All extends zio.aws.codepipeline.model.StartTimeRange {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StartTimeRange =
      software.amazon.awssdk.services.codepipeline.model.StartTimeRange.ALL
  }
}
