package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SucceededInStageFilter(
    stageName: Optional[StageName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.SucceededInStageFilter = {
    import SucceededInStageFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.SucceededInStageFilter
      .builder()
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly =
    zio.aws.codepipeline.model.SucceededInStageFilter.wrap(buildAwsValue())
}
object SucceededInStageFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.SucceededInStageFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.SucceededInStageFilter =
      zio.aws.codepipeline.model
        .SucceededInStageFilter(stageName.map(value => value))
    def stageName: Optional[StageName]
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.SucceededInStageFilter
  ) extends zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly {
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.SucceededInStageFilter
  ): zio.aws.codepipeline.model.SucceededInStageFilter.ReadOnly = new Wrapper(
    impl
  )
}
