package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SuccessConditions(
    conditions: Iterable[zio.aws.codepipeline.model.Condition]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.SuccessConditions = {
    import SuccessConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.SuccessConditions
      .builder()
      .conditions(conditions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.SuccessConditions.ReadOnly =
    zio.aws.codepipeline.model.SuccessConditions.wrap(buildAwsValue())
}
object SuccessConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.SuccessConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.SuccessConditions =
      zio.aws.codepipeline.model.SuccessConditions(conditions.map { item =>
        item.asEditable
      })
    def conditions: List[zio.aws.codepipeline.model.Condition.ReadOnly]
    def getConditions: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.Condition.ReadOnly
    ]] = ZIO.succeed(conditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.SuccessConditions
  ) extends zio.aws.codepipeline.model.SuccessConditions.ReadOnly {
    override val conditions
        : List[zio.aws.codepipeline.model.Condition.ReadOnly] = impl
      .conditions()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.Condition.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.SuccessConditions
  ): zio.aws.codepipeline.model.SuccessConditions.ReadOnly = new Wrapper(impl)
}
