package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait WebhookAuthenticationType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType
}
object WebhookAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType
  ): zio.aws.codepipeline.model.WebhookAuthenticationType = value match {
    case software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.GITHUB_HMAC =>
      val r = GITHUB_HMAC
      r
    case software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.IP =>
      val r = IP
      r
    case software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.UNAUTHENTICATED =>
      val r = UNAUTHENTICATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.WebhookAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType =
      software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object GITHUB_HMAC
      extends zio.aws.codepipeline.model.WebhookAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType =
      software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.GITHUB_HMAC
  }
  case object IP extends zio.aws.codepipeline.model.WebhookAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType =
      software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.IP
  }
  case object UNAUTHENTICATED
      extends zio.aws.codepipeline.model.WebhookAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType =
      software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType.UNAUTHENTICATED
  }
}
