package zio.aws.codepipeline
import zio.aws.codepipeline.model.primitives.{
  RuleConfigurationValue,
  ActionConfigurationKey,
  GitTagNamePattern,
  ServicePrincipal,
  AccountId,
  GitBranchNamePattern,
  OutputVariablesKey,
  RuleConfigurationKey,
  ActionConfigurationValue,
  GitFilePathPattern,
  FilePath,
  ActionConfigurationQueryableValue,
  OutputVariable,
  AllowedAccount,
  Command,
  AWSRegionName,
  TagKey,
  OutputVariablesValue
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codepipeline.model.primitives.JsonPath.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSRegionName extends zio.prelude.Subtype[String]
    type AWSRegionName =
      zio.aws.codepipeline.model.primitives.AWSRegionName.Type
    object AccessKeyId extends zio.prelude.Subtype[String]
    type AccessKeyId = zio.aws.codepipeline.model.primitives.AccessKeyId.Type
    object AccountId extends zio.prelude.Subtype[String]
    type AccountId = zio.aws.codepipeline.model.primitives.AccountId.Type
    object ActionConfigurationKey extends zio.prelude.Subtype[String]
    type ActionConfigurationKey =
      zio.aws.codepipeline.model.primitives.ActionConfigurationKey.Type
    object ActionConfigurationQueryableValue extends zio.prelude.Subtype[String]
    type ActionConfigurationQueryableValue =
      zio.aws.codepipeline.model.primitives.ActionConfigurationQueryableValue.Type
    object ActionConfigurationValue extends zio.prelude.Subtype[String]
    type ActionConfigurationValue =
      zio.aws.codepipeline.model.primitives.ActionConfigurationValue.Type
    object ActionExecutionId extends zio.prelude.Subtype[String]
    type ActionExecutionId =
      zio.aws.codepipeline.model.primitives.ActionExecutionId.Type
    object ActionExecutionToken extends zio.prelude.Subtype[String]
    type ActionExecutionToken =
      zio.aws.codepipeline.model.primitives.ActionExecutionToken.Type
    object ActionName extends zio.prelude.Subtype[String]
    type ActionName = zio.aws.codepipeline.model.primitives.ActionName.Type
    object ActionNamespace extends zio.prelude.Subtype[String]
    type ActionNamespace =
      zio.aws.codepipeline.model.primitives.ActionNamespace.Type
    object ActionProvider extends zio.prelude.Subtype[String]
    type ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider.Type
    object ActionRunOrder extends zio.prelude.Subtype[Int]
    type ActionRunOrder =
      zio.aws.codepipeline.model.primitives.ActionRunOrder.Type
    object ActionTimeout extends zio.prelude.Subtype[Int]
    type ActionTimeout =
      zio.aws.codepipeline.model.primitives.ActionTimeout.Type
    object ActionTypeDescription extends zio.prelude.Subtype[String]
    type ActionTypeDescription =
      zio.aws.codepipeline.model.primitives.ActionTypeDescription.Type
    object ActionTypeOwner extends zio.prelude.Subtype[String]
    type ActionTypeOwner =
      zio.aws.codepipeline.model.primitives.ActionTypeOwner.Type
    object AllowedAccount extends zio.prelude.Subtype[String]
    type AllowedAccount =
      zio.aws.codepipeline.model.primitives.AllowedAccount.Type
    object ApprovalSummary extends zio.prelude.Subtype[String]
    type ApprovalSummary =
      zio.aws.codepipeline.model.primitives.ApprovalSummary.Type
    object ApprovalToken extends zio.prelude.Subtype[String]
    type ApprovalToken =
      zio.aws.codepipeline.model.primitives.ApprovalToken.Type
    object ArtifactName extends zio.prelude.Subtype[String]
    type ArtifactName = zio.aws.codepipeline.model.primitives.ArtifactName.Type
    object ArtifactStoreLocation extends zio.prelude.Subtype[String]
    type ArtifactStoreLocation =
      zio.aws.codepipeline.model.primitives.ArtifactStoreLocation.Type
    object BlockerName extends zio.prelude.Subtype[String]
    type BlockerName = zio.aws.codepipeline.model.primitives.BlockerName.Type
    object ClientId extends zio.prelude.Subtype[String]
    type ClientId = zio.aws.codepipeline.model.primitives.ClientId.Type
    object ClientRequestToken extends zio.prelude.Subtype[String]
    type ClientRequestToken =
      zio.aws.codepipeline.model.primitives.ClientRequestToken.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.codepipeline.model.primitives.ClientToken.Type
    object Code extends zio.prelude.Subtype[String]
    type Code = zio.aws.codepipeline.model.primitives.Code.Type
    object Command extends zio.prelude.Subtype[String]
    type Command = zio.aws.codepipeline.model.primitives.Command.Type
    object ContinuationToken extends zio.prelude.Subtype[String]
    type ContinuationToken =
      zio.aws.codepipeline.model.primitives.ContinuationToken.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.codepipeline.model.primitives.Description.Type
    object DisabledReason extends zio.prelude.Subtype[String]
    type DisabledReason =
      zio.aws.codepipeline.model.primitives.DisabledReason.Type
    object Enabled extends zio.prelude.Subtype[Boolean]
    type Enabled = zio.aws.codepipeline.model.primitives.Enabled.Type
    object EncryptionKeyId extends zio.prelude.Subtype[String]
    type EncryptionKeyId =
      zio.aws.codepipeline.model.primitives.EncryptionKeyId.Type
    object EnvironmentVariableName extends zio.prelude.Subtype[String]
    type EnvironmentVariableName =
      zio.aws.codepipeline.model.primitives.EnvironmentVariableName.Type
    object EnvironmentVariableValue extends zio.prelude.Subtype[String]
    type EnvironmentVariableValue =
      zio.aws.codepipeline.model.primitives.EnvironmentVariableValue.Type
    object ExecutionId extends zio.prelude.Subtype[String]
    type ExecutionId = zio.aws.codepipeline.model.primitives.ExecutionId.Type
    object ExecutionSummary extends zio.prelude.Subtype[String]
    type ExecutionSummary =
      zio.aws.codepipeline.model.primitives.ExecutionSummary.Type
    object ExternalExecutionId extends zio.prelude.Subtype[String]
    type ExternalExecutionId =
      zio.aws.codepipeline.model.primitives.ExternalExecutionId.Type
    object ExternalExecutionSummary extends zio.prelude.Subtype[String]
    type ExternalExecutionSummary =
      zio.aws.codepipeline.model.primitives.ExternalExecutionSummary.Type
    object FilePath extends zio.prelude.Subtype[String]
    type FilePath = zio.aws.codepipeline.model.primitives.FilePath.Type
    object GitBranchNamePattern extends zio.prelude.Subtype[String]
    type GitBranchNamePattern =
      zio.aws.codepipeline.model.primitives.GitBranchNamePattern.Type
    object GitFilePathPattern extends zio.prelude.Subtype[String]
    type GitFilePathPattern =
      zio.aws.codepipeline.model.primitives.GitFilePathPattern.Type
    object GitTagNamePattern extends zio.prelude.Subtype[String]
    type GitTagNamePattern =
      zio.aws.codepipeline.model.primitives.GitTagNamePattern.Type
    object JobId extends zio.prelude.Subtype[String]
    type JobId = zio.aws.codepipeline.model.primitives.JobId.Type
    object JobTimeout extends zio.prelude.Subtype[Int]
    type JobTimeout = zio.aws.codepipeline.model.primitives.JobTimeout.Type
    object JsonPath extends zio.prelude.Subtype[String]
    type JsonPath = zio.aws.codepipeline.model.primitives.JsonPath.Type
    object LambdaFunctionArn extends zio.prelude.Subtype[String]
    type LambdaFunctionArn =
      zio.aws.codepipeline.model.primitives.LambdaFunctionArn.Type
    object LastChangedAt extends zio.prelude.Subtype[Instant]
    type LastChangedAt =
      zio.aws.codepipeline.model.primitives.LastChangedAt.Type
    object LastChangedBy extends zio.prelude.Subtype[String]
    type LastChangedBy =
      zio.aws.codepipeline.model.primitives.LastChangedBy.Type
    object LastUpdatedBy extends zio.prelude.Subtype[String]
    type LastUpdatedBy =
      zio.aws.codepipeline.model.primitives.LastUpdatedBy.Type
    object LogStreamARN extends zio.prelude.Subtype[String]
    type LogStreamARN = zio.aws.codepipeline.model.primitives.LogStreamARN.Type
    object MatchEquals extends zio.prelude.Subtype[String]
    type MatchEquals = zio.aws.codepipeline.model.primitives.MatchEquals.Type
    object MaxBatchSize extends zio.prelude.Subtype[Int]
    type MaxBatchSize = zio.aws.codepipeline.model.primitives.MaxBatchSize.Type
    object MaxPipelines extends zio.prelude.Subtype[Int]
    type MaxPipelines = zio.aws.codepipeline.model.primitives.MaxPipelines.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.codepipeline.model.primitives.MaxResults.Type
    object MaximumActionTypeArtifactCount extends zio.prelude.Subtype[Int]
    type MaximumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives.MaximumActionTypeArtifactCount.Type
    object MaximumArtifactCount extends zio.prelude.Subtype[Int]
    type MaximumArtifactCount =
      zio.aws.codepipeline.model.primitives.MaximumArtifactCount.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.codepipeline.model.primitives.Message.Type
    object MinimumActionTypeArtifactCount extends zio.prelude.Subtype[Int]
    type MinimumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives.MinimumActionTypeArtifactCount.Type
    object MinimumArtifactCount extends zio.prelude.Subtype[Int]
    type MinimumArtifactCount =
      zio.aws.codepipeline.model.primitives.MinimumArtifactCount.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.codepipeline.model.primitives.NextToken.Type
    object Nonce extends zio.prelude.Subtype[String]
    type Nonce = zio.aws.codepipeline.model.primitives.Nonce.Type
    object OutputVariable extends zio.prelude.Subtype[String]
    type OutputVariable =
      zio.aws.codepipeline.model.primitives.OutputVariable.Type
    object OutputVariablesKey extends zio.prelude.Subtype[String]
    type OutputVariablesKey =
      zio.aws.codepipeline.model.primitives.OutputVariablesKey.Type
    object OutputVariablesValue extends zio.prelude.Subtype[String]
    type OutputVariablesValue =
      zio.aws.codepipeline.model.primitives.OutputVariablesValue.Type
    object Percentage extends zio.prelude.Subtype[Int]
    type Percentage = zio.aws.codepipeline.model.primitives.Percentage.Type
    object PipelineArn extends zio.prelude.Subtype[String]
    type PipelineArn = zio.aws.codepipeline.model.primitives.PipelineArn.Type
    object PipelineExecutionId extends zio.prelude.Subtype[String]
    type PipelineExecutionId =
      zio.aws.codepipeline.model.primitives.PipelineExecutionId.Type
    object PipelineExecutionStatusSummary extends zio.prelude.Subtype[String]
    type PipelineExecutionStatusSummary =
      zio.aws.codepipeline.model.primitives.PipelineExecutionStatusSummary.Type
    object PipelineName extends zio.prelude.Subtype[String]
    type PipelineName = zio.aws.codepipeline.model.primitives.PipelineName.Type
    object PipelineVariableDescription extends zio.prelude.Subtype[String]
    type PipelineVariableDescription =
      zio.aws.codepipeline.model.primitives.PipelineVariableDescription.Type
    object PipelineVariableName extends zio.prelude.Subtype[String]
    type PipelineVariableName =
      zio.aws.codepipeline.model.primitives.PipelineVariableName.Type
    object PipelineVariableValue extends zio.prelude.Subtype[String]
    type PipelineVariableValue =
      zio.aws.codepipeline.model.primitives.PipelineVariableValue.Type
    object PipelineVersion extends zio.prelude.Subtype[Int]
    type PipelineVersion =
      zio.aws.codepipeline.model.primitives.PipelineVersion.Type
    object PolicyStatementsTemplate extends zio.prelude.Subtype[String]
    type PolicyStatementsTemplate =
      zio.aws.codepipeline.model.primitives.PolicyStatementsTemplate.Type
    object PropertyDescription extends zio.prelude.Subtype[String]
    type PropertyDescription =
      zio.aws.codepipeline.model.primitives.PropertyDescription.Type
    object ResourceArn extends zio.prelude.Subtype[String]
    type ResourceArn = zio.aws.codepipeline.model.primitives.ResourceArn.Type
    object RetryAttempt extends zio.prelude.Subtype[Int]
    type RetryAttempt = zio.aws.codepipeline.model.primitives.RetryAttempt.Type
    object Revision extends zio.prelude.Subtype[String]
    type Revision = zio.aws.codepipeline.model.primitives.Revision.Type
    object RevisionChangeIdentifier extends zio.prelude.Subtype[String]
    type RevisionChangeIdentifier =
      zio.aws.codepipeline.model.primitives.RevisionChangeIdentifier.Type
    object RevisionSummary extends zio.prelude.Subtype[String]
    type RevisionSummary =
      zio.aws.codepipeline.model.primitives.RevisionSummary.Type
    object RoleArn extends zio.prelude.Subtype[String]
    type RoleArn = zio.aws.codepipeline.model.primitives.RoleArn.Type
    object RuleConfigurationKey extends zio.prelude.Subtype[String]
    type RuleConfigurationKey =
      zio.aws.codepipeline.model.primitives.RuleConfigurationKey.Type
    object RuleConfigurationValue extends zio.prelude.Subtype[String]
    type RuleConfigurationValue =
      zio.aws.codepipeline.model.primitives.RuleConfigurationValue.Type
    object RuleExecutionId extends zio.prelude.Subtype[String]
    type RuleExecutionId =
      zio.aws.codepipeline.model.primitives.RuleExecutionId.Type
    object RuleExecutionToken extends zio.prelude.Subtype[String]
    type RuleExecutionToken =
      zio.aws.codepipeline.model.primitives.RuleExecutionToken.Type
    object RuleName extends zio.prelude.Subtype[String]
    type RuleName = zio.aws.codepipeline.model.primitives.RuleName.Type
    object RuleProvider extends zio.prelude.Subtype[String]
    type RuleProvider = zio.aws.codepipeline.model.primitives.RuleProvider.Type
    object RuleTimeout extends zio.prelude.Subtype[Int]
    type RuleTimeout = zio.aws.codepipeline.model.primitives.RuleTimeout.Type
    object S3Bucket extends zio.prelude.Subtype[String]
    type S3Bucket = zio.aws.codepipeline.model.primitives.S3Bucket.Type
    object S3BucketName extends zio.prelude.Subtype[String]
    type S3BucketName = zio.aws.codepipeline.model.primitives.S3BucketName.Type
    object S3Key extends zio.prelude.Subtype[String]
    type S3Key = zio.aws.codepipeline.model.primitives.S3Key.Type
    object S3ObjectKey extends zio.prelude.Subtype[String]
    type S3ObjectKey = zio.aws.codepipeline.model.primitives.S3ObjectKey.Type
    object SecretAccessKey extends zio.prelude.Subtype[String]
    type SecretAccessKey =
      zio.aws.codepipeline.model.primitives.SecretAccessKey.Type
    object ServicePrincipal extends zio.prelude.Subtype[String]
    type ServicePrincipal =
      zio.aws.codepipeline.model.primitives.ServicePrincipal.Type
    object SessionToken extends zio.prelude.Subtype[String]
    type SessionToken = zio.aws.codepipeline.model.primitives.SessionToken.Type
    object StageName extends zio.prelude.Subtype[String]
    type StageName = zio.aws.codepipeline.model.primitives.StageName.Type
    object StopPipelineExecutionReason extends zio.prelude.Subtype[String]
    type StopPipelineExecutionReason =
      zio.aws.codepipeline.model.primitives.StopPipelineExecutionReason.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.codepipeline.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.codepipeline.model.primitives.TagValue.Type
    object ThirdPartyJobId extends zio.prelude.Subtype[String]
    type ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId.Type
    object Time extends zio.prelude.Subtype[Instant]
    type Time = zio.aws.codepipeline.model.primitives.Time.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.codepipeline.model.primitives.Timestamp.Type
    object TriggerDetail extends zio.prelude.Subtype[String]
    type TriggerDetail =
      zio.aws.codepipeline.model.primitives.TriggerDetail.Type
    object Url extends zio.prelude.Subtype[String]
    type Url = zio.aws.codepipeline.model.primitives.Url.Type
    object UrlTemplate extends zio.prelude.Subtype[String]
    type UrlTemplate = zio.aws.codepipeline.model.primitives.UrlTemplate.Type
    object Version extends zio.prelude.Subtype[String]
    type Version = zio.aws.codepipeline.model.primitives.Version.Type
    object WebhookArn extends zio.prelude.Subtype[String]
    type WebhookArn = zio.aws.codepipeline.model.primitives.WebhookArn.Type
    object WebhookAuthConfigurationAllowedIPRange
        extends zio.prelude.Subtype[String]
    type WebhookAuthConfigurationAllowedIPRange =
      zio.aws.codepipeline.model.primitives.WebhookAuthConfigurationAllowedIPRange.Type
    object WebhookAuthConfigurationSecretToken
        extends zio.prelude.Subtype[String]
    type WebhookAuthConfigurationSecretToken =
      zio.aws.codepipeline.model.primitives.WebhookAuthConfigurationSecretToken.Type
    object WebhookErrorCode extends zio.prelude.Subtype[String]
    type WebhookErrorCode =
      zio.aws.codepipeline.model.primitives.WebhookErrorCode.Type
    object WebhookErrorMessage extends zio.prelude.Subtype[String]
    type WebhookErrorMessage =
      zio.aws.codepipeline.model.primitives.WebhookErrorMessage.Type
    object WebhookLastTriggered extends zio.prelude.Subtype[Instant]
    type WebhookLastTriggered =
      zio.aws.codepipeline.model.primitives.WebhookLastTriggered.Type
    object WebhookName extends zio.prelude.Subtype[String]
    type WebhookName = zio.aws.codepipeline.model.primitives.WebhookName.Type
    object WebhookUrl extends zio.prelude.Subtype[String]
    type WebhookUrl = zio.aws.codepipeline.model.primitives.WebhookUrl.Type
  }
  type ActionConfigurationMap =
    Map[ActionConfigurationKey, ActionConfigurationValue]
  type ActionConfigurationPropertyList =
    List[zio.aws.codepipeline.model.ActionConfigurationProperty]
  type ActionExecutionDetailList =
    List[zio.aws.codepipeline.model.ActionExecutionDetail]
  type ActionStateList = List[zio.aws.codepipeline.model.ActionState]
  type ActionTypeList = List[zio.aws.codepipeline.model.ActionType]
  type ActionTypeProperties =
    List[zio.aws.codepipeline.model.ActionTypeProperty]
  type AllowedAccounts = List[AllowedAccount]
  type ArtifactDetailList = List[zio.aws.codepipeline.model.ArtifactDetail]
  type ArtifactList = List[zio.aws.codepipeline.model.Artifact]
  type ArtifactRevisionList = List[zio.aws.codepipeline.model.ArtifactRevision]
  type ArtifactStoreMap =
    Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore]
  type CommandList = List[Command]
  type ConditionList = List[zio.aws.codepipeline.model.Condition]
  type ConditionStateList = List[zio.aws.codepipeline.model.ConditionState]
  type EnvironmentVariableList =
    List[zio.aws.codepipeline.model.EnvironmentVariable]
  type FilePathList = List[FilePath]
  type GitBranchPatternList = List[GitBranchNamePattern]
  type GitFilePathPatternList = List[GitFilePathPattern]
  type GitPullRequestEventTypeList =
    List[zio.aws.codepipeline.model.GitPullRequestEventType]
  type GitPullRequestFilterList =
    List[zio.aws.codepipeline.model.GitPullRequestFilter]
  type GitPushFilterList = List[zio.aws.codepipeline.model.GitPushFilter]
  type GitTagPatternList = List[GitTagNamePattern]
  type InputArtifactList = List[zio.aws.codepipeline.model.InputArtifact]
  type JobList = List[zio.aws.codepipeline.model.Job]
  type OutputArtifactList = List[zio.aws.codepipeline.model.OutputArtifact]
  type OutputVariableList = List[OutputVariable]
  type OutputVariablesMap = Map[OutputVariablesKey, OutputVariablesValue]
  type PipelineExecutionSummaryList =
    List[zio.aws.codepipeline.model.PipelineExecutionSummary]
  type PipelineList = List[zio.aws.codepipeline.model.PipelineSummary]
  type PipelineStageDeclarationList =
    List[zio.aws.codepipeline.model.StageDeclaration]
  type PipelineTriggerDeclarationList =
    List[zio.aws.codepipeline.model.PipelineTriggerDeclaration]
  type PipelineVariableDeclarationList =
    List[zio.aws.codepipeline.model.PipelineVariableDeclaration]
  type PipelineVariableList = List[zio.aws.codepipeline.model.PipelineVariable]
  type PollingAccountList = List[AccountId]
  type PollingServicePrincipalList = List[ServicePrincipal]
  type QueryParamMap =
    Map[ActionConfigurationKey, ActionConfigurationQueryableValue]
  type ResolvedActionConfigurationMap = Map[String, String]
  type ResolvedPipelineVariableList =
    List[zio.aws.codepipeline.model.ResolvedPipelineVariable]
  type ResolvedRuleConfigurationMap = Map[String, String]
  type RuleConfigurationMap = Map[RuleConfigurationKey, RuleConfigurationValue]
  type RuleConfigurationPropertyList =
    List[zio.aws.codepipeline.model.RuleConfigurationProperty]
  type RuleDeclarationList = List[zio.aws.codepipeline.model.RuleDeclaration]
  type RuleExecutionDetailList =
    List[zio.aws.codepipeline.model.RuleExecutionDetail]
  type RuleStateList = List[zio.aws.codepipeline.model.RuleState]
  type RuleTypeList = List[zio.aws.codepipeline.model.RuleType]
  type SourceRevisionList = List[zio.aws.codepipeline.model.SourceRevision]
  type SourceRevisionOverrideList =
    List[zio.aws.codepipeline.model.SourceRevisionOverride]
  type StageActionDeclarationList =
    List[zio.aws.codepipeline.model.ActionDeclaration]
  type StageBlockerDeclarationList =
    List[zio.aws.codepipeline.model.BlockerDeclaration]
  type StageExecutionList = List[zio.aws.codepipeline.model.StageExecution]
  type StageStateList = List[zio.aws.codepipeline.model.StageState]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.codepipeline.model.Tag]
  type ThirdPartyJobList = List[zio.aws.codepipeline.model.ThirdPartyJob]
  type WebhookFilters = List[zio.aws.codepipeline.model.WebhookFilterRule]
  type WebhookList = List[zio.aws.codepipeline.model.ListWebhookItem]
}
