package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{UrlTemplate, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActionTypeUrls(
    configurationUrl: Optional[Url] = Optional.Absent,
    entityUrlTemplate: Optional[UrlTemplate] = Optional.Absent,
    executionUrlTemplate: Optional[UrlTemplate] = Optional.Absent,
    revisionUrlTemplate: Optional[UrlTemplate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls = {
    import ActionTypeUrls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
      .builder()
      .optionallyWith(
        configurationUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.configurationUrl)
      .optionallyWith(
        entityUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.entityUrlTemplate)
      .optionallyWith(
        executionUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.executionUrlTemplate)
      .optionallyWith(
        revisionUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.revisionUrlTemplate)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeUrls.wrap(buildAwsValue())
}
object ActionTypeUrls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeUrls =
      zio.aws.codepipeline.model.ActionTypeUrls(
        configurationUrl.map(value => value),
        entityUrlTemplate.map(value => value),
        executionUrlTemplate.map(value => value),
        revisionUrlTemplate.map(value => value)
      )
    def configurationUrl: Optional[Url]
    def entityUrlTemplate: Optional[UrlTemplate]
    def executionUrlTemplate: Optional[UrlTemplate]
    def revisionUrlTemplate: Optional[UrlTemplate]
    def getConfigurationUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("configurationUrl", configurationUrl)
    def getEntityUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("entityUrlTemplate", entityUrlTemplate)
    def getExecutionUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("executionUrlTemplate", executionUrlTemplate)
    def getRevisionUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("revisionUrlTemplate", revisionUrlTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ) extends zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly {
    override val configurationUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val entityUrlTemplate: Optional[UrlTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityUrlTemplate())
        .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
    override val executionUrlTemplate: Optional[UrlTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionUrlTemplate())
        .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
    override val revisionUrlTemplate: Optional[UrlTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionUrlTemplate())
        .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ): zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly = new Wrapper(impl)
}
