package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ConditionExecutionStatus {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus
}
object ConditionExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus
  ): zio.aws.codepipeline.model.ConditionExecutionStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.ERRORED =>
      val r = Errored
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.ABANDONED =>
      val r = Abandoned
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.OVERRIDDEN =>
      val r = Overridden
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.IN_PROGRESS
  }
  case object Failed
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.FAILED
  }
  case object Errored
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.ERRORED
  }
  case object Succeeded
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.SUCCEEDED
  }
  case object Cancelled
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.CANCELLED
  }
  case object Abandoned
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.ABANDONED
  }
  case object Overridden
      extends zio.aws.codepipeline.model.ConditionExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.ConditionExecutionStatus.OVERRIDDEN
  }
}
