package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConditionState(
    latestExecution: Optional[zio.aws.codepipeline.model.ConditionExecution] =
      Optional.Absent,
    ruleStates: Optional[Iterable[zio.aws.codepipeline.model.RuleState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ConditionState = {
    import ConditionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ConditionState
      .builder()
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .optionallyWith(
        ruleStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleStates)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ConditionState.ReadOnly =
    zio.aws.codepipeline.model.ConditionState.wrap(buildAwsValue())
}
object ConditionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ConditionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ConditionState =
      zio.aws.codepipeline.model.ConditionState(
        latestExecution.map(value => value.asEditable),
        ruleStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def latestExecution
        : Optional[zio.aws.codepipeline.model.ConditionExecution.ReadOnly]
    def ruleStates
        : Optional[List[zio.aws.codepipeline.model.RuleState.ReadOnly]]
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ConditionExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
    def getRuleStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.RuleState.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleStates", ruleStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ConditionState
  ) extends zio.aws.codepipeline.model.ConditionState.ReadOnly {
    override val latestExecution
        : Optional[zio.aws.codepipeline.model.ConditionExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestExecution())
        .map(value => zio.aws.codepipeline.model.ConditionExecution.wrap(value))
    override val ruleStates
        : Optional[List[zio.aws.codepipeline.model.RuleState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.RuleState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ConditionState
  ): zio.aws.codepipeline.model.ConditionState.ReadOnly = new Wrapper(impl)
}
