package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ConditionType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ConditionType
}
object ConditionType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ConditionType
  ): zio.aws.codepipeline.model.ConditionType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ConditionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionType.BEFORE_ENTRY =>
      val r = BEFORE_ENTRY
      r
    case software.amazon.awssdk.services.codepipeline.model.ConditionType.ON_SUCCESS =>
      val r = ON_SUCCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ConditionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionType =
      software.amazon.awssdk.services.codepipeline.model.ConditionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BEFORE_ENTRY extends zio.aws.codepipeline.model.ConditionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionType =
      software.amazon.awssdk.services.codepipeline.model.ConditionType.BEFORE_ENTRY
  }
  case object ON_SUCCESS extends zio.aws.codepipeline.model.ConditionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ConditionType =
      software.amazon.awssdk.services.codepipeline.model.ConditionType.ON_SUCCESS
  }
}
