package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetJobDetailsResponse(
    jobDetails: Optional[zio.aws.codepipeline.model.JobDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse = {
    import GetJobDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse
      .builder()
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly =
    zio.aws.codepipeline.model.GetJobDetailsResponse.wrap(buildAwsValue())
}
object GetJobDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetJobDetailsResponse =
      zio.aws.codepipeline.model
        .GetJobDetailsResponse(jobDetails.map(value => value.asEditable))
    def jobDetails: Optional[zio.aws.codepipeline.model.JobDetails.ReadOnly]
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse
  ) extends zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly {
    override val jobDetails
        : Optional[zio.aws.codepipeline.model.JobDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.codepipeline.model.JobDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse
  ): zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly = new Wrapper(
    impl
  )
}
