package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRuleExecutionsResponse(
    ruleExecutionDetails: Optional[
      Iterable[zio.aws.codepipeline.model.RuleExecutionDetail]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse = {
    import ListRuleExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse
      .builder()
      .optionallyWith(
        ruleExecutionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleExecutionDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListRuleExecutionsResponse.ReadOnly =
    zio.aws.codepipeline.model.ListRuleExecutionsResponse.wrap(buildAwsValue())
}
object ListRuleExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListRuleExecutionsResponse =
      zio.aws.codepipeline.model.ListRuleExecutionsResponse(
        ruleExecutionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ruleExecutionDetails: Optional[
      List[zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getRuleExecutionDetails: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ruleExecutionDetails", ruleExecutionDetails)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse
  ) extends zio.aws.codepipeline.model.ListRuleExecutionsResponse.ReadOnly {
    override val ruleExecutionDetails: Optional[
      List[zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleExecutionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.RuleExecutionDetail.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse
  ): zio.aws.codepipeline.model.ListRuleExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
