package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PipelineTriggerDeclaration(
    providerType: zio.aws.codepipeline.model.PipelineTriggerProviderType,
    gitConfiguration: zio.aws.codepipeline.model.GitConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration = {
    import PipelineTriggerDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration
      .builder()
      .providerType(providerType.unwrap)
      .gitConfiguration(gitConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly =
    zio.aws.codepipeline.model.PipelineTriggerDeclaration.wrap(buildAwsValue())
}
object PipelineTriggerDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineTriggerDeclaration =
      zio.aws.codepipeline.model
        .PipelineTriggerDeclaration(providerType, gitConfiguration.asEditable)
    def providerType: zio.aws.codepipeline.model.PipelineTriggerProviderType
    def gitConfiguration: zio.aws.codepipeline.model.GitConfiguration.ReadOnly
    def getProviderType: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.PipelineTriggerProviderType
    ] = ZIO.succeed(providerType)
    def getGitConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.GitConfiguration.ReadOnly
    ] = ZIO.succeed(gitConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration
  ) extends zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly {
    override val providerType
        : zio.aws.codepipeline.model.PipelineTriggerProviderType =
      zio.aws.codepipeline.model.PipelineTriggerProviderType
        .wrap(impl.providerType())
    override val gitConfiguration
        : zio.aws.codepipeline.model.GitConfiguration.ReadOnly =
      zio.aws.codepipeline.model.GitConfiguration.wrap(impl.gitConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration
  ): zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly =
    new Wrapper(impl)
}
