package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait Result {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.Result
}
object Result {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.Result
  ): zio.aws.codepipeline.model.Result = value match {
    case software.amazon.awssdk.services.codepipeline.model.Result.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.Result.ROLLBACK =>
      val r = ROLLBACK
      r
    case software.amazon.awssdk.services.codepipeline.model.Result.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.codepipeline.model.Result.RETRY =>
      val r = RETRY
      r
    case software.amazon.awssdk.services.codepipeline.model.Result.SKIP =>
      val r = SKIP
      r
  }
  case object unknownToSdkVersion extends zio.aws.codepipeline.model.Result {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.Result =
      software.amazon.awssdk.services.codepipeline.model.Result.UNKNOWN_TO_SDK_VERSION
  }
  case object ROLLBACK extends zio.aws.codepipeline.model.Result {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.Result =
      software.amazon.awssdk.services.codepipeline.model.Result.ROLLBACK
  }
  case object FAIL extends zio.aws.codepipeline.model.Result {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.Result =
      software.amazon.awssdk.services.codepipeline.model.Result.FAIL
  }
  case object RETRY extends zio.aws.codepipeline.model.Result {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.Result =
      software.amazon.awssdk.services.codepipeline.model.Result.RETRY
  }
  case object SKIP extends zio.aws.codepipeline.model.Result {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.Result =
      software.amazon.awssdk.services.codepipeline.model.Result.SKIP
  }
}
