package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetryConfiguration(
    retryMode: Optional[zio.aws.codepipeline.model.StageRetryMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RetryConfiguration = {
    import RetryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RetryConfiguration
      .builder()
      .optionallyWith(retryMode.map(value => value.unwrap))(_.retryMode)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RetryConfiguration.ReadOnly =
    zio.aws.codepipeline.model.RetryConfiguration.wrap(buildAwsValue())
}
object RetryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RetryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RetryConfiguration =
      zio.aws.codepipeline.model
        .RetryConfiguration(retryMode.map(value => value))
    def retryMode: Optional[zio.aws.codepipeline.model.StageRetryMode]
    def getRetryMode
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.StageRetryMode] =
      AwsError.unwrapOptionField("retryMode", retryMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryConfiguration
  ) extends zio.aws.codepipeline.model.RetryConfiguration.ReadOnly {
    override val retryMode
        : Optional[zio.aws.codepipeline.model.StageRetryMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryMode())
        .map(value => zio.aws.codepipeline.model.StageRetryMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryConfiguration
  ): zio.aws.codepipeline.model.RetryConfiguration.ReadOnly = new Wrapper(impl)
}
