package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RollbackStageResponse(
    pipelineExecutionId: PipelineExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse = {
    import RollbackStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse
      .builder()
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RollbackStageResponse.ReadOnly =
    zio.aws.codepipeline.model.RollbackStageResponse.wrap(buildAwsValue())
}
object RollbackStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RollbackStageResponse =
      zio.aws.codepipeline.model.RollbackStageResponse(pipelineExecutionId)
    def pipelineExecutionId: PipelineExecutionId
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse
  ) extends zio.aws.codepipeline.model.RollbackStageResponse.ReadOnly {
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse
  ): zio.aws.codepipeline.model.RollbackStageResponse.ReadOnly = new Wrapper(
    impl
  )
}
