package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait RuleConfigurationPropertyType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType
}
object RuleConfigurationPropertyType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType
  ): zio.aws.codepipeline.model.RuleConfigurationPropertyType = value match {
    case software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.BOOLEAN =>
      val r = Boolean
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.RuleConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.UNKNOWN_TO_SDK_VERSION
  }
  case object String
      extends zio.aws.codepipeline.model.RuleConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.STRING
  }
  case object Number
      extends zio.aws.codepipeline.model.RuleConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.NUMBER
  }
  case object Boolean
      extends zio.aws.codepipeline.model.RuleConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType.BOOLEAN
  }
}
