package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  AWSRegionName,
  RoleArn,
  RuleConfigurationValue,
  RuleConfigurationKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleExecutionInput(
    ruleTypeId: Optional[zio.aws.codepipeline.model.RuleTypeId] =
      Optional.Absent,
    configuration: Optional[Map[RuleConfigurationKey, RuleConfigurationValue]] =
      Optional.Absent,
    resolvedConfiguration: Optional[Map[String, String]] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    region: Optional[AWSRegionName] = Optional.Absent,
    inputArtifacts: Optional[
      Iterable[zio.aws.codepipeline.model.ArtifactDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput = {
    import RuleExecutionInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput
      .builder()
      .optionallyWith(ruleTypeId.map(value => value.buildAwsValue()))(
        _.ruleTypeId
      )
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (RuleConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (RuleConfigurationValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        resolvedConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.resolvedConfiguration)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        region.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly =
    zio.aws.codepipeline.model.RuleExecutionInput.wrap(buildAwsValue())
}
object RuleExecutionInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecutionInput =
      zio.aws.codepipeline.model.RuleExecutionInput(
        ruleTypeId.map(value => value.asEditable),
        configuration.map(value => value),
        resolvedConfiguration.map(value => value),
        roleArn.map(value => value),
        region.map(value => value),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ruleTypeId: Optional[zio.aws.codepipeline.model.RuleTypeId.ReadOnly]
    def configuration
        : Optional[Map[RuleConfigurationKey, RuleConfigurationValue]]
    def resolvedConfiguration: Optional[Map[String, String]]
    def roleArn: Optional[RoleArn]
    def region: Optional[AWSRegionName]
    def inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]]
    def getRuleTypeId
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleTypeId.ReadOnly] =
      AwsError.unwrapOptionField("ruleTypeId", ruleTypeId)
    def getConfiguration: ZIO[Any, AwsError, Map[
      RuleConfigurationKey,
      RuleConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getResolvedConfiguration: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("resolvedConfiguration", resolvedConfiguration)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRegion: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("region", region)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ArtifactDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput
  ) extends zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly {
    override val ruleTypeId
        : Optional[zio.aws.codepipeline.model.RuleTypeId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleTypeId())
        .map(value => zio.aws.codepipeline.model.RuleTypeId.wrap(value))
    override val configuration
        : Optional[Map[RuleConfigurationKey, RuleConfigurationValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codepipeline.model.primitives.RuleConfigurationKey(
                key
              ) -> zio.aws.codepipeline.model.primitives
                .RuleConfigurationValue(value)
            })
            .toMap
        )
    override val resolvedConfiguration: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedConfiguration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.codepipeline.model.primitives.RoleArn(value))
    override val region: Optional[AWSRegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
    override val inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ArtifactDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput
  ): zio.aws.codepipeline.model.RuleExecutionInput.ReadOnly = new Wrapper(impl)
}
