package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleExecutionOutput(
    executionResult: Optional[zio.aws.codepipeline.model.RuleExecutionResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput = {
    import RuleExecutionOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput
      .builder()
      .optionallyWith(executionResult.map(value => value.buildAwsValue()))(
        _.executionResult
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly =
    zio.aws.codepipeline.model.RuleExecutionOutput.wrap(buildAwsValue())
}
object RuleExecutionOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecutionOutput =
      zio.aws.codepipeline.model
        .RuleExecutionOutput(executionResult.map(value => value.asEditable))
    def executionResult
        : Optional[zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly]
    def getExecutionResult: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly
    ] = AwsError.unwrapOptionField("executionResult", executionResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput
  ) extends zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly {
    override val executionResult
        : Optional[zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionResult())
        .map(value =>
          zio.aws.codepipeline.model.RuleExecutionResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput
  ): zio.aws.codepipeline.model.RuleExecutionOutput.ReadOnly = new Wrapper(impl)
}
