package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Url,
  ExternalExecutionSummary,
  ExternalExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleExecutionResult(
    externalExecutionId: Optional[ExternalExecutionId] = Optional.Absent,
    externalExecutionSummary: Optional[ExternalExecutionSummary] =
      Optional.Absent,
    externalExecutionUrl: Optional[Url] = Optional.Absent,
    errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionResult = {
    import RuleExecutionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionResult
      .builder()
      .optionallyWith(
        externalExecutionId.map(value =>
          ExternalExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        externalExecutionSummary.map(value =>
          ExternalExecutionSummary.unwrap(value): java.lang.String
        )
      )(_.externalExecutionSummary)
      .optionallyWith(
        externalExecutionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.externalExecutionUrl)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly =
    zio.aws.codepipeline.model.RuleExecutionResult.wrap(buildAwsValue())
}
object RuleExecutionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecutionResult =
      zio.aws.codepipeline.model.RuleExecutionResult(
        externalExecutionId.map(value => value),
        externalExecutionSummary.map(value => value),
        externalExecutionUrl.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def externalExecutionId: Optional[ExternalExecutionId]
    def externalExecutionSummary: Optional[ExternalExecutionSummary]
    def externalExecutionUrl: Optional[Url]
    def errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly]
    def getExternalExecutionId: ZIO[Any, AwsError, ExternalExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getExternalExecutionSummary
        : ZIO[Any, AwsError, ExternalExecutionSummary] = AwsError
      .unwrapOptionField("externalExecutionSummary", externalExecutionSummary)
    def getExternalExecutionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("externalExecutionUrl", externalExecutionUrl)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionResult
  ) extends zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly {
    override val externalExecutionId: Optional[ExternalExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ExternalExecutionId(value)
        )
    override val externalExecutionSummary: Optional[ExternalExecutionSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalExecutionSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ExternalExecutionSummary(value)
        )
    override val externalExecutionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.externalExecutionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val errorDetails
        : Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.codepipeline.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionResult
  ): zio.aws.codepipeline.model.RuleExecutionResult.ReadOnly = new Wrapper(impl)
}
