package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Url, RuleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleState(
    ruleName: Optional[RuleName] = Optional.Absent,
    currentRevision: Optional[zio.aws.codepipeline.model.RuleRevision] =
      Optional.Absent,
    latestExecution: Optional[zio.aws.codepipeline.model.RuleExecution] =
      Optional.Absent,
    entityUrl: Optional[Url] = Optional.Absent,
    revisionUrl: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleState = {
    import RuleState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleState
      .builder()
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(currentRevision.map(value => value.buildAwsValue()))(
        _.currentRevision
      )
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .optionallyWith(
        entityUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.entityUrl)
      .optionallyWith(
        revisionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.revisionUrl)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleState.ReadOnly =
    zio.aws.codepipeline.model.RuleState.wrap(buildAwsValue())
}
object RuleState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleState =
      zio.aws.codepipeline.model.RuleState(
        ruleName.map(value => value),
        currentRevision.map(value => value.asEditable),
        latestExecution.map(value => value.asEditable),
        entityUrl.map(value => value),
        revisionUrl.map(value => value)
      )
    def ruleName: Optional[RuleName]
    def currentRevision
        : Optional[zio.aws.codepipeline.model.RuleRevision.ReadOnly]
    def latestExecution
        : Optional[zio.aws.codepipeline.model.RuleExecution.ReadOnly]
    def entityUrl: Optional[Url]
    def revisionUrl: Optional[Url]
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getCurrentRevision
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleRevision.ReadOnly] =
      AwsError.unwrapOptionField("currentRevision", currentRevision)
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RuleExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
    def getEntityUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("entityUrl", entityUrl)
    def getRevisionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("revisionUrl", revisionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleState
  ) extends zio.aws.codepipeline.model.RuleState.ReadOnly {
    override val ruleName: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.codepipeline.model.primitives.RuleName(value))
    override val currentRevision
        : Optional[zio.aws.codepipeline.model.RuleRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentRevision())
        .map(value => zio.aws.codepipeline.model.RuleRevision.wrap(value))
    override val latestExecution
        : Optional[zio.aws.codepipeline.model.RuleExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestExecution())
        .map(value => zio.aws.codepipeline.model.RuleExecution.wrap(value))
    override val entityUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.entityUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val revisionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleState
  ): zio.aws.codepipeline.model.RuleState.ReadOnly = new Wrapper(impl)
}
