package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageDeclaration(
    name: StageName,
    blockers: Optional[
      Iterable[zio.aws.codepipeline.model.BlockerDeclaration]
    ] = Optional.Absent,
    actions: Iterable[zio.aws.codepipeline.model.ActionDeclaration],
    onFailure: Optional[zio.aws.codepipeline.model.FailureConditions] =
      Optional.Absent,
    onSuccess: Optional[zio.aws.codepipeline.model.SuccessConditions] =
      Optional.Absent,
    beforeEntry: Optional[zio.aws.codepipeline.model.BeforeEntryConditions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageDeclaration = {
    import StageDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageDeclaration
      .builder()
      .name(StageName.unwrap(name): java.lang.String)
      .optionallyWith(
        blockers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockers)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(onFailure.map(value => value.buildAwsValue()))(
        _.onFailure
      )
      .optionallyWith(onSuccess.map(value => value.buildAwsValue()))(
        _.onSuccess
      )
      .optionallyWith(beforeEntry.map(value => value.buildAwsValue()))(
        _.beforeEntry
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageDeclaration.ReadOnly =
    zio.aws.codepipeline.model.StageDeclaration.wrap(buildAwsValue())
}
object StageDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageDeclaration =
      zio.aws.codepipeline.model.StageDeclaration(
        name,
        blockers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map { item =>
          item.asEditable
        },
        onFailure.map(value => value.asEditable),
        onSuccess.map(value => value.asEditable),
        beforeEntry.map(value => value.asEditable)
      )
    def name: StageName
    def blockers
        : Optional[List[zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly]]
    def actions: List[zio.aws.codepipeline.model.ActionDeclaration.ReadOnly]
    def onFailure
        : Optional[zio.aws.codepipeline.model.FailureConditions.ReadOnly]
    def onSuccess
        : Optional[zio.aws.codepipeline.model.SuccessConditions.ReadOnly]
    def beforeEntry
        : Optional[zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly]
    def getName: ZIO[Any, Nothing, StageName] = ZIO.succeed(name)
    def getBlockers: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("blockers", blockers)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.ActionDeclaration.ReadOnly
    ]] = ZIO.succeed(actions)
    def getOnFailure: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.FailureConditions.ReadOnly
    ] = AwsError.unwrapOptionField("onFailure", onFailure)
    def getOnSuccess: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.SuccessConditions.ReadOnly
    ] = AwsError.unwrapOptionField("onSuccess", onSuccess)
    def getBeforeEntry: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly
    ] = AwsError.unwrapOptionField("beforeEntry", beforeEntry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ) extends zio.aws.codepipeline.model.StageDeclaration.ReadOnly {
    override val name: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.name())
    override val blockers: Optional[
      List[zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.BlockerDeclaration.wrap(item)
        }.toList
      )
    override val actions
        : List[zio.aws.codepipeline.model.ActionDeclaration.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.ActionDeclaration.wrap(item)
      }
      .toList
    override val onFailure
        : Optional[zio.aws.codepipeline.model.FailureConditions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onFailure())
        .map(value => zio.aws.codepipeline.model.FailureConditions.wrap(value))
    override val onSuccess
        : Optional[zio.aws.codepipeline.model.SuccessConditions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onSuccess())
        .map(value => zio.aws.codepipeline.model.SuccessConditions.wrap(value))
    override val beforeEntry
        : Optional[zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beforeEntry())
        .map(value =>
          zio.aws.codepipeline.model.BeforeEntryConditions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ): zio.aws.codepipeline.model.StageDeclaration.ReadOnly = new Wrapper(impl)
}
