package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ClientRequestToken, PipelineName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartPipelineExecutionRequest(
    name: PipelineName,
    variables: Optional[Iterable[zio.aws.codepipeline.model.PipelineVariable]] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    sourceRevisions: Optional[
      Iterable[zio.aws.codepipeline.model.SourceRevisionOverride]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest = {
    import StartPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .optionallyWith(
        variables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variables)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        sourceRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceRevisions)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly =
    zio.aws.codepipeline.model.StartPipelineExecutionRequest
      .wrap(buildAwsValue())
}
object StartPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StartPipelineExecutionRequest =
      zio.aws.codepipeline.model.StartPipelineExecutionRequest(
        name,
        variables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        sourceRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: PipelineName
    def variables
        : Optional[List[zio.aws.codepipeline.model.PipelineVariable.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def sourceRevisions: Optional[
      List[zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
    def getVariables: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.PipelineVariable.ReadOnly
    ]] = AwsError.unwrapOptionField("variables", variables)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSourceRevisions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceRevisions", sourceRevisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ) extends zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
    override val variables
        : Optional[List[zio.aws.codepipeline.model.PipelineVariable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.PipelineVariable.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ClientRequestToken(value)
        )
    override val sourceRevisions: Optional[
      List[zio.aws.codepipeline.model.SourceRevisionOverride.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRevisions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.SourceRevisionOverride.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ): zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
