package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{RemoteAccessAllowed, Role, UserArn}
import scala.jdk.CollectionConverters._
final case class TeamMember(
    userArn: UserArn,
    projectRole: Role,
    remoteAccessAllowed: Optional[RemoteAccessAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.TeamMember = {
    import TeamMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.TeamMember
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .projectRole(Role.unwrap(projectRole): java.lang.String)
      .optionallyWith(
        remoteAccessAllowed.map(value =>
          RemoteAccessAllowed.unwrap(value): java.lang.Boolean
        )
      )(_.remoteAccessAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.TeamMember.ReadOnly =
    zio.aws.codestar.model.TeamMember.wrap(buildAwsValue())
}
object TeamMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.TeamMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.TeamMember = zio.aws.codestar.model
      .TeamMember(userArn, projectRole, remoteAccessAllowed.map(value => value))
    def userArn: UserArn
    def projectRole: Role
    def remoteAccessAllowed: Optional[RemoteAccessAllowed]
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getProjectRole: ZIO[Any, Nothing, Role] = ZIO.succeed(projectRole)
    def getRemoteAccessAllowed: ZIO[Any, AwsError, RemoteAccessAllowed] =
      AwsError.unwrapOptionField("remoteAccessAllowed", remoteAccessAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.TeamMember
  ) extends zio.aws.codestar.model.TeamMember.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val projectRole: Role =
      zio.aws.codestar.model.primitives.Role(impl.projectRole())
    override val remoteAccessAllowed: Optional[RemoteAccessAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessAllowed())
        .map(value =>
          zio.aws.codestar.model.primitives.RemoteAccessAllowed(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.TeamMember
  ): zio.aws.codestar.model.TeamMember.ReadOnly = new Wrapper(impl)
}
