package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CodeDestination(
    codeCommit: Option[zio.aws.codestar.model.CodeCommitCodeDestination] = None,
    gitHub: Option[zio.aws.codestar.model.GitHubCodeDestination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CodeDestination = {
    import CodeDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CodeDestination
      .builder()
      .optionallyWith(codeCommit.map(value => value.buildAwsValue()))(
        _.codeCommit
      )
      .optionallyWith(gitHub.map(value => value.buildAwsValue()))(_.gitHub)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CodeDestination.ReadOnly =
    zio.aws.codestar.model.CodeDestination.wrap(buildAwsValue())
}
object CodeDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CodeDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CodeDestination =
      zio.aws.codestar.model.CodeDestination(
        codeCommit.map(value => value.asEditable),
        gitHub.map(value => value.asEditable)
      )
    def codeCommit
        : Option[zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly]
    def gitHub: Option[zio.aws.codestar.model.GitHubCodeDestination.ReadOnly]
    def getCodeCommit: ZIO[
      Any,
      AwsError,
      zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly
    ] = AwsError.unwrapOptionField("codeCommit", codeCommit)
    def getGitHub: ZIO[
      Any,
      AwsError,
      zio.aws.codestar.model.GitHubCodeDestination.ReadOnly
    ] = AwsError.unwrapOptionField("gitHub", gitHub)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CodeDestination
  ) extends zio.aws.codestar.model.CodeDestination.ReadOnly {
    override val codeCommit
        : Option[zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly] =
      scala
        .Option(impl.codeCommit())
        .map(value =>
          zio.aws.codestar.model.CodeCommitCodeDestination.wrap(value)
        )
    override val gitHub
        : Option[zio.aws.codestar.model.GitHubCodeDestination.ReadOnly] = scala
      .Option(impl.gitHub())
      .map(value => zio.aws.codestar.model.GitHubCodeDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CodeDestination
  ): zio.aws.codestar.model.CodeDestination.ReadOnly = new Wrapper(impl)
}
