package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  ProjectName,
  ProjectId,
  ClientRequestToken,
  TagValue,
  ProjectDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    name: ProjectName,
    id: ProjectId,
    description: Option[ProjectDescription] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    sourceCode: Option[Iterable[zio.aws.codestar.model.Code]] = None,
    toolchain: Option[zio.aws.codestar.model.Toolchain] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CreateProjectRequest
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .id(ProjectId.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        sourceCode.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceCode)
      .optionallyWith(toolchain.map(value => value.buildAwsValue()))(
        _.toolchain
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CreateProjectRequest.ReadOnly =
    zio.aws.codestar.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CreateProjectRequest =
      zio.aws.codestar.model.CreateProjectRequest(
        name,
        id,
        description.map(value => value),
        clientRequestToken.map(value => value),
        sourceCode.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        toolchain.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: ProjectName
    def id: ProjectId
    def description: Option[ProjectDescription]
    def clientRequestToken: Option[ClientRequestToken]
    def sourceCode: Option[List[zio.aws.codestar.model.Code.ReadOnly]]
    def toolchain: Option[zio.aws.codestar.model.Toolchain.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSourceCode
        : ZIO[Any, AwsError, List[zio.aws.codestar.model.Code.ReadOnly]] =
      AwsError.unwrapOptionField("sourceCode", sourceCode)
    def getToolchain
        : ZIO[Any, AwsError, zio.aws.codestar.model.Toolchain.ReadOnly] =
      AwsError.unwrapOptionField("toolchain", toolchain)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CreateProjectRequest
  ) extends zio.aws.codestar.model.CreateProjectRequest.ReadOnly {
    override val name: ProjectName =
      zio.aws.codestar.model.primitives.ProjectName(impl.name())
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val description: Option[ProjectDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.codestar.model.primitives.ProjectDescription(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.codestar.model.primitives.ClientRequestToken(value))
    override val sourceCode
        : Option[List[zio.aws.codestar.model.Code.ReadOnly]] = scala
      .Option(impl.sourceCode())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestar.model.Code.wrap(item)
        }.toList
      )
    override val toolchain: Option[zio.aws.codestar.model.Toolchain.ReadOnly] =
      scala
        .Option(impl.toolchain())
        .map(value => zio.aws.codestar.model.Toolchain.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestar.model.primitives
              .TagKey(key) -> zio.aws.codestar.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CreateProjectRequest
  ): zio.aws.codestar.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
